/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileIOChannel;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.jcr.storage.value.ValueStoragePlugin;
import org.exoplatform.services.log.ExoLogger;

public class SimpleFileValueStorage
extends ValueStoragePlugin {
    protected static Log log = ExoLogger.getLogger((String)"jcr.SimpleFileValueStorage");
    public static final String PATH = "path";
    private File rootDir;
    protected final FileCleaner cleaner = new FileCleaner();

    public void init(Properties props) throws IOException {
        this.prepareRootDir(props.getProperty(PATH));
    }

    protected void prepareRootDir(String rootDirPath) throws IOException {
        this.rootDir = new File(rootDirPath);
        if (!this.rootDir.exists()) {
            if (this.rootDir.mkdirs()) {
                log.info((Object)("Directory created: " + this.rootDir.getAbsolutePath()));
            } else {
                log.warn((Object)("Directory IS NOT created: " + this.rootDir.getAbsolutePath()));
            }
        } else if (!this.rootDir.isDirectory()) {
            throw new IOException("File exists but is not a directory " + rootDirPath);
        }
    }

    public ValueIOChannel openIOChannel() throws IOException {
        return new FileIOChannel(this.rootDir, this.cleaner);
    }

    public void checkConsistency(WorkspaceStorageConnection dataConnection) {
        File[] deletedBefore = this.rootDir.listFiles(new DeletedFilesFilter());
        if (deletedBefore != null) {
            for (File markerFile : deletedBefore) {
                int delExtSize = "del".length() + 1;
                String markerPath = markerFile.getAbsolutePath();
                File dataFile = new File(markerPath.substring(0, markerPath.length() - delExtSize));
                if (dataFile.exists()) {
                    String markerName = markerFile.getName();
                    String propertyId = markerName.substring(0, markerName.length() - delExtSize);
                    try {
                        ItemData item = dataConnection.getItemData(propertyId);
                        if (item == null) {
                            if (!dataFile.delete()) {
                                log.warn((Object)("Can't delete 'phantom' data file " + dataFile.getAbsolutePath()));
                            } else {
                                log.info((Object)("A 'phantom' data file deleted " + dataFile.getAbsolutePath()));
                            }
                        } else {
                            log.warn((Object)("Item data marked as deleted exists in repository with propertyId " + propertyId + ". The 'phantom' marker file will be deleted but data file doesn't."));
                        }
                        if (markerFile.delete()) continue;
                        log.warn((Object)("Can't delete 'phantom' marker file " + markerFile.getAbsolutePath()));
                    }
                    catch (RepositoryException e) {
                        log.error((Object)("Value file storage repository error of 'phantom' item data (" + propertyId + ") check. " + e.getMessage()));
                    }
                    catch (IllegalStateException e) {
                        log.error((Object)("Value file storage error of 'phantom' item data (" + propertyId + ") check. " + e.getMessage()));
                    }
                    continue;
                }
                log.warn((Object)("Delete 'phantom' marker file (no 'phantom' file exists) " + markerFile.getAbsolutePath()));
                if (markerFile.delete()) continue;
                log.warn((Object)("Can't delete 'phantom' marker file (no 'phantom' file exists) " + markerFile.getAbsolutePath()));
            }
        }
    }

    private class DeletedFilesFilter
    implements FileFilter {
        private DeletedFilesFilter() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith("del");
        }
    }
}

