/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.ISO9075;
import org.exoplatform.services.jcr.impl.util.StringConverter;
import org.exoplatform.services.jcr.impl.xml.ImporterBase;
import org.exoplatform.services.jcr.util.UUIDGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DocNodeImporter
extends ImporterBase {
    private static Log log = ExoLogger.getLogger((String)"jcr.DocNodeImporter");
    private Stack<NodeData> tree = new Stack();
    private TransientPropertyData XmlCharactersProperty = null;
    private String XmlCharactersPropertyValue = null;
    private boolean saveOnEnd = false;
    private String primaryNodeType;

    public DocNodeImporter(NodeImpl parent, int uuidBehavior) throws RepositoryException {
        super(parent, uuidBehavior);
        this.tree.push((NodeData)parent.getData());
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String nodeName = ISO9075.decode(qName);
        this.primaryNodeType = "nt:unstructured";
        if ("jcr:root".equals(nodeName)) {
            nodeName = "";
        }
        ArrayList<ExtendedNodeType> nodeTypes = new ArrayList<ExtendedNodeType>();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("jcr:primaryType", Constants.NT_UNSTRUCTURED.getAsString());
        try {
            nodeTypes.add((ExtendedNodeType)this.ntManager.getNodeType(this.primaryNodeType));
        }
        catch (RepositoryException e) {
            throw new SAXException("impossible state");
        }
        ArrayList<InternalQName> mixinNodeTypes = new ArrayList<InternalQName>();
        this.parseAttr(nodeName, atts, nodeTypes, mixinNodeTypes, props);
        TransientNodeData nodeData = null;
        try {
            boolean isMixReferenceable = this.isReferenceable(nodeTypes);
            String uuid = this.validateUuidCollision(nodeName, isMixReferenceable, nodeTypes, props);
            if (uuid == null) {
                uuid = UUIDGenerator.generate();
            }
            InternalQName jcrName = this.locationFactory.parseJCRName(nodeName).getInternalName();
            InternalQPath dstNodePath = InternalQPath.makeChildPath((InternalQPath)this.parent().getQPath(), (InternalQName)jcrName);
            int nodeIndex = this.getNodeIndex(dstNodePath);
            nodeData = TransientNodeData.createNodeData(this.parent(), jcrName, this.locationFactory.parseJCRName(this.primaryNodeType).getInternalName(), nodeIndex);
            nodeData.setMixinTypeNames(mixinNodeTypes.toArray(new InternalQName[mixinNodeTypes.size()]));
            nodeData.setUUID(uuid);
            this.itemStatesList.add(new ItemState((ItemData)nodeData, 1, true, this.parent().getQPath()));
            this.tree.push((NodeData)nodeData);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Node : " + nodeData.getQPath().getAsString()));
            }
            Iterator<String> keys = props.keySet().iterator();
            while (keys.hasNext()) {
                TransientPropertyData newProperty = null;
                String key = keys.next();
                if (key.equals("jcr:primaryType")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Property NAME: " + key + "=" + props.get(key)));
                    }
                    newProperty = TransientPropertyData.createPropertyData(this.parent(), Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(props.get(key)));
                } else if (key.equals("jcr:mixinTypes")) {
                    ArrayList<ValueData> valuesData = new ArrayList<ValueData>(mixinNodeTypes.size());
                    for (InternalQName mixinQname : mixinNodeTypes) {
                        valuesData.add(new TransientValueData(mixinQname));
                    }
                    newProperty = TransientPropertyData.createPropertyData(this.parent(), this.locationFactory.parseJCRName(key).getInternalName(), 7, false, valuesData);
                } else if (isMixReferenceable && key.equals("jcr:uuid")) {
                    Value value = this.session.getValueFactory().createValue(nodeData.getUUID(), 1);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Property STRING: " + key + "=" + value.getString()));
                    }
                    newProperty = TransientPropertyData.createPropertyData(this.parent(), Constants.JCR_UUID, 1, false, new TransientValueData(uuid));
                } else {
                    PropertyDefinition pDef = this.getPropertyDefinition(key, nodeTypes);
                    if (pDef.getRequiredType() == 2) {
                        if (log.isDebugEnabled()) {
                            String pb = props.get(key);
                            if (pb.length() > 512) {
                                pb = pb.substring(0, 512);
                            }
                            log.debug((Object)("Property BINARY: " + key + "=" + (pb.length() > 0 ? new String(Base64.decodeBase64((byte[])pb.getBytes())) : "[empty data]")));
                        }
                        newProperty = TransientPropertyData.createPropertyData(this.parent(), this.locationFactory.parseJCRName(key).getInternalName(), 2, false, new TransientValueData(new ByteArrayInputStream(Base64.decodeBase64((byte[])props.get(key).getBytes()))));
                    } else {
                        int pType = pDef.getRequiredType() > 0 ? pDef.getRequiredType() : 1;
                        Value value = this.session.getValueFactory().createValue(StringConverter.denormalizeString(props.get(key)), pType);
                        if (log.isDebugEnabled()) {
                            String valueAsString = null;
                            try {
                                valueAsString = value.getString();
                            }
                            catch (Exception e) {
                                log.error((Object)("Can't present value as string. " + e.getMessage()));
                                valueAsString = "[Can't present value as string]";
                            }
                            log.debug((Object)("Property " + PropertyType.nameFromValue((int)pType) + ": " + key + "=" + valueAsString));
                        }
                        newProperty = TransientPropertyData.createPropertyData(this.parent(), this.locationFactory.parseJCRName(key).getInternalName(), pType, false, ((BaseValue)value).getInternalData());
                    }
                }
                this.itemStatesList.add(new ItemState((ItemData)newProperty, 1, true, this.parent().getQPath()));
            }
        }
        catch (Exception e) {
            log.error((Object)("Error in import: " + e.getMessage()));
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.tree.pop();
        this.XmlCharactersProperty = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuilder text = new StringBuilder();
        text.append(ch, start, length);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Property:xmltext=" + text + " Parent=" + this.parent().getQPath().getAsString()));
        }
        if (this.XmlCharactersProperty != null) {
            this.XmlCharactersPropertyValue = this.XmlCharactersPropertyValue + text.toString();
            this.XmlCharactersProperty.setValue(new TransientValueData(this.XmlCharactersPropertyValue));
        } else {
            TransientNodeData nodeData = TransientNodeData.createNodeData(this.parent(), Constants.JCR_XMLTEXT, Constants.NT_UNSTRUCTURED);
            this.itemStatesList.add(new ItemState((ItemData)nodeData, 1, true, this.parent().getQPath()));
            TransientPropertyData newProperty = TransientPropertyData.createPropertyData((NodeData)nodeData, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(Constants.NT_UNSTRUCTURED));
            this.itemStatesList.add(new ItemState((ItemData)newProperty, 1, true, nodeData.getQPath()));
            newProperty = TransientPropertyData.createPropertyData((NodeData)nodeData, Constants.JCR_XMLCHARACTERS, 1, false, new TransientValueData(text.toString()));
            this.itemStatesList.add(new ItemState((ItemData)newProperty, 1, true, nodeData.getQPath()));
            this.XmlCharactersProperty = newProperty;
            this.XmlCharactersPropertyValue = text.toString();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private NodeData parent() {
        return this.tree.peek();
    }

    public boolean isSaveOnEnd() {
        return this.saveOnEnd;
    }

    public void setSaveOnEnd(boolean saveOnEnd) {
        this.saveOnEnd = saveOnEnd;
    }

    private void parseAttr(String nodeName, Attributes atts, List<ExtendedNodeType> nodeTypes, List<InternalQName> mixinNodeTypes, HashMap<String, String> props) throws SAXException {
        if (atts != null) {
            try {
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attrQName = atts.getQName(i);
                    String attValue = atts.getValue(i);
                    String propName = !"".equals(attrQName) ? ISO9075.decode(attrQName) : atts.getLocalName(i);
                    if (propName.equals("jcr:primaryType")) {
                        this.primaryNodeType = StringConverter.denormalizeString(attValue);
                        InternalQName ntName = this.locationFactory.parseJCRName(this.primaryNodeType).getInternalName();
                        nodeTypes.add(this.ntManager.getNodeType(ntName));
                        props.put(propName, ntName.getAsString());
                        continue;
                    }
                    if (propName.equals("jcr:mixinTypes")) {
                        String[] amTypes = attValue.split(" ");
                        for (int mi = 0; mi < amTypes.length; ++mi) {
                            amTypes[mi] = StringConverter.denormalizeString(amTypes[mi]);
                            mixinNodeTypes.add(this.locationFactory.parseJCRName(amTypes[mi]).getInternalName());
                            nodeTypes.add((ExtendedNodeType)this.ntManager.getNodeType(amTypes[mi]));
                        }
                        props.put(propName, null);
                        continue;
                    }
                    if (propName.equals("jcr:uuid")) {
                        props.put(propName, attValue);
                        continue;
                    }
                    props.put(propName, attValue);
                }
            }
            catch (RepositoryException e) {
                log.error((Object)("Error in node properties import, " + nodeName + ": " + e.getMessage()), (Throwable)e);
                throw new SAXException("Error in node properties import, " + nodeName + ": " + e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private String validateUuidCollision(String nodeName, boolean hasMixReferenceable, List<ExtendedNodeType> nodeTypes, HashMap<String, String> props) throws SAXException, RepositoryException {
        String uuid = props.get("jcr:uuid");
        NodeData parentNodeData = this.parent();
        ItemDataRemoveVisitor visitor = null;
        List<ItemState> removedStates = null;
        if (hasMixReferenceable && uuid != null) {
            try {
                NodeImpl sameUuidNode = (NodeImpl)this.session.getNodeByUUID(uuid);
                switch (this.uuidBehavior) {
                    case 0: {
                        uuid = null;
                        break;
                    }
                    case 1: {
                        NodeIterator samePatterns = sameUuidNode.getNodes(parentNodeData.getQPath().getName().getName());
                        if (samePatterns.hasNext()) {
                            throw new ConstraintViolationException("A uuidBehavior is set to IMPORT_UUID_COLLISION_REMOVE_EXISTING and an incoming node has the same UUID as the node at parentAbsPath or one of its ancestors");
                        }
                        visitor = new ItemDataRemoveVisitor(this.session, true);
                        sameUuidNode.getData().accept((ItemDataVisitor)visitor);
                        removedStates = visitor.getRemovedStates();
                        this.itemStatesList.addAll(removedStates);
                        break;
                    }
                    case 2: {
                        parentNodeData = (NodeData)((NodeImpl)sameUuidNode.getParent()).getData();
                        visitor = new ItemDataRemoveVisitor(this.session, true);
                        sameUuidNode.getData().accept((ItemDataVisitor)visitor);
                        removedStates = visitor.getRemovedStates();
                        this.itemStatesList.addAll(removedStates);
                        this.tree.push(parentNodeData);
                        break;
                    }
                    case 3: {
                        throw new ItemExistsException("An incoming referenceable node has the same UUID as a node already existing in the workspace!");
                    }
                }
            }
            catch (ItemNotFoundException e) {
                // empty catch block
            }
        }
        return uuid;
    }
}

