/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.core.value.BinaryValue;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.xml.ContentHandlerWrapper;
import org.exoplatform.services.jcr.util.io.BLOBUtil;
import org.exoplatform.services.log.ExoLogger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class ExporterBase {
    protected static Log log = ExoLogger.getLogger((String)"jcr.ExporterBase");
    protected Session session;
    private Map sessionNamespaces = new Hashtable();
    protected ContentHandler contentHandler = new ContentHandlerWrapper(null);
    private ContentHandler customerContentHandler;
    private boolean recurse = false;
    public static final int BINARY_PROCESS = 0;
    public static final int BINARY_SKIP = 1;
    public static final int BINARY_EMPTY = 2;
    private int binaryConduct = 0;

    public ExporterBase(Session session) throws RepositoryException {
        if (session == null) {
            throw new IllegalArgumentException("session can't be null");
        }
        this.session = session;
    }

    public ContentHandler getContentHandler() {
        return this.customerContentHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Can't set null handler");
        }
        this.customerContentHandler = handler;
        this.contentHandler = new ContentHandlerWrapper(handler);
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public void setRecurse(boolean isRecurse) {
        this.recurse = isRecurse;
    }

    public int getBinaryConduct() {
        return this.binaryConduct;
    }

    public void setBinaryConduct(int binaryConduct) {
        if (binaryConduct != 0 && binaryConduct != 1 && binaryConduct != 2) {
            throw new IllegalArgumentException("binaryConduct must be one of BINARY_PROCESS,BINARY_SKIP, BINARY_EMPTY");
        }
        this.binaryConduct = binaryConduct;
    }

    private String getInputStreamAsBase64(InputStream inputStream) throws IOException {
        StringBuffer strBuf = new StringBuffer("");
        long totalReadBytes = 0L;
        if (inputStream != null) {
            byte[] byteArray = new byte[1024];
            while (inputStream.available() > 0) {
                byte[] readByteArray;
                int readBytes = inputStream.read(byteArray);
                totalReadBytes += (long)readBytes;
                if (readBytes == byteArray.length) {
                    readByteArray = byteArray;
                } else {
                    readByteArray = new byte[readBytes];
                    System.arraycopy(byteArray, 0, readByteArray, 0, readBytes);
                }
                strBuf.append(new String(Base64.encodeBase64((byte[])readByteArray)));
            }
        }
        log.debug((Object)("Read " + totalReadBytes + " bytes from binary value"));
        return strBuf.toString();
    }

    protected String getValueAsString(Value value) throws RepositoryException {
        if (value.getType() != 2) {
            return value.getString();
        }
        TransientValueData valueData = ((BaseValue)value).getInternalData();
        try {
            String b64s = new String(Base64.encodeBase64((byte[])BLOBUtil.readValue((ValueData)valueData)));
            return b64s;
        }
        catch (IOException e) {
            throw new RepositoryException("Can't export value to string: " + e.getMessage(), (Throwable)e);
        }
    }

    protected Collection getNamespacePrefixes() {
        return this.sessionNamespaces.keySet();
    }

    protected String getNamespaceURI(String prefix) throws RepositoryException {
        if (prefix.equals("")) {
            return "";
        }
        String uri = (String)this.sessionNamespaces.get(prefix);
        if (uri == null) {
            throw new RepositoryException("No namespace uri found for prefix '" + prefix + "'");
        }
        return uri;
    }

    protected String getItemQName(Item item) throws RepositoryException {
        String result = item.getName();
        if (result.equals("") && item.isNode()) {
            result = "jcr:root";
        }
        return result;
    }

    protected String getItemNsPrefix(Item item) throws RepositoryException {
        String prefix = "";
        String qName = this.getItemQName(item);
        if (qName.indexOf(58) != -1) {
            prefix = qName.substring(0, qName.indexOf(58));
        }
        return prefix;
    }

    protected String getItemNsURI(Item item) throws RepositoryException {
        return this.getNamespaceURI(this.getItemNsPrefix(item));
    }

    protected String getItemLocalName(Item item) throws RepositoryException {
        String qName;
        String localName = qName = this.getItemQName(item);
        if (qName.indexOf(58) != -1) {
            localName = qName.substring(qName.indexOf(58) + 1, qName.length());
        }
        return localName;
    }

    protected String getPropertyType(Property property) throws RepositoryException {
        return ExtendedPropertyType.nameFromValue((int)property.getType());
    }

    public final void export(NodeImpl node) throws RepositoryException, SAXException {
        if (node == null) {
            log.error((Object)"Specified Node is null");
            throw new IllegalArgumentException("node can't be null ");
        }
        if (this.contentHandler != null) {
            log.debug((Object)"start export");
            this.contentHandler.startDocument();
            this.readNamespaces();
            this.startNamespaceScope();
            this.nodeProcess(node);
            this.endNamespaceScope();
            this.contentHandler.endDocument();
        }
    }

    private void propertyProcess(Property property) throws RepositoryException, SAXException {
        Value[] values;
        log.trace((Object)("propertyProcess [" + property.getPath() + "]"));
        this.startProperty(property);
        try {
            values = new Value[]{property.getValue()};
        }
        catch (ValueFormatException ex) {
            values = property.getValues();
        }
        this.startPropertyValues(property);
        for (int i = 0; i < values.length; ++i) {
            this.processValue(values[i]);
        }
        this.endPropertyValues(property);
        this.endProperty(property);
    }

    private void processValue(Value value) throws RepositoryException, SAXException {
        if (value.getType() == 2) {
            if (this.getBinaryConduct() == 1) {
                return;
            }
            if (this.getBinaryConduct() == 2) {
                try {
                    value = new BinaryValue("");
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
        }
        this.exportValue((Value)value);
    }

    private void nodeProcess(NodeImpl node) throws SAXException, RepositoryException {
        log.trace((Object)("nodeProcess [" + node.getPath() + "]"));
        this.startNode((Node)node);
        this.startNodeProperties((Node)node);
        for (PropertyImpl prop : node.childProperties()) {
            this.propertyProcess(prop);
        }
        this.endNodeProperties((Node)node);
        if (this.isRecurse()) {
            for (NodeImpl nextNode : node.childNodes()) {
                this.nodeProcess(nextNode);
            }
        }
        this.endNode((Node)node);
    }

    private void readNamespaces() throws RepositoryException {
        log.debug((Object)"Read namespace definitions from session");
        String[] prefixes = this.session.getNamespacePrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            if (prefixes[i].length() <= 0) continue;
            this.sessionNamespaces.put(prefixes[i], this.session.getNamespaceURI(prefixes[i]));
        }
    }

    private void startNamespaceScope() throws RepositoryException, SAXException {
        log.debug((Object)"start namespace scope");
        for (String prefix : this.getNamespacePrefixes()) {
            this.contentHandler.startPrefixMapping(prefix, this.getNamespaceURI(prefix));
        }
    }

    private void endNamespaceScope() throws RepositoryException, SAXException {
        log.debug((Object)"end namespace scope");
        Iterator prefixIterator = this.getNamespacePrefixes().iterator();
        while (prefixIterator.hasNext()) {
            this.contentHandler.endPrefixMapping((String)prefixIterator.next());
        }
    }

    protected void startNode(Node node) throws RepositoryException, SAXException {
    }

    protected void endNode(Node node) throws RepositoryException, SAXException {
    }

    protected void startNodeProperties(Node node) throws RepositoryException, SAXException {
    }

    protected void endNodeProperties(Node node) throws RepositoryException, SAXException {
    }

    protected void startProperty(Property property) throws RepositoryException, SAXException {
    }

    protected void endProperty(Property property) throws RepositoryException, SAXException {
    }

    protected void startPropertyValues(Property property) throws RepositoryException, SAXException {
    }

    protected void endPropertyValues(Property property) throws RepositoryException, SAXException {
    }

    protected void exportValue(Value value) throws RepositoryException, SAXException {
    }
}

