/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.services.jcr.impl.xml.ExporterBase;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ExporterSysView
extends ExporterBase {
    private final String SV_NAMESPACE_URI;

    public ExporterSysView(Session session) throws RepositoryException {
        super(session);
        this.SV_NAMESPACE_URI = session.getNamespaceURI("sv");
    }

    protected void startNode(Node node) throws RepositoryException, SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(this.SV_NAMESPACE_URI, "name", "sv:name", "CDATA", this.getItemQName((Item)node));
        this.contentHandler.startElement(this.SV_NAMESPACE_URI, "node", "sv:node", atts);
    }

    protected void endNode(Node node) throws RepositoryException, SAXException {
        this.contentHandler.endElement(this.SV_NAMESPACE_URI, "node", "sv:node");
    }

    protected void startProperty(Property property) throws RepositoryException, SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(this.SV_NAMESPACE_URI, "name", "sv:name", "CDATA", property.getName());
        atts.addAttribute(this.SV_NAMESPACE_URI, "type", "sv:type", "CDATA", this.getPropertyType(property));
        this.contentHandler.startElement(this.SV_NAMESPACE_URI, "property", "sv:property", atts);
    }

    protected void endProperty(Property property) throws RepositoryException, SAXException {
        this.contentHandler.endElement(this.SV_NAMESPACE_URI, "property", "sv:property");
    }

    protected void exportValue(Value value) throws RepositoryException, SAXException {
        this.contentHandler.startElement(this.SV_NAMESPACE_URI, "value", "sv:value", new AttributesImpl());
        char[] charValue = this.getValueAsString(value).toCharArray();
        this.contentHandler.characters(charValue, 0, charValue.length);
        this.contentHandler.endElement(this.SV_NAMESPACE_URI, "value", "sv:value");
    }
}

