/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import java.util.Properties;
import java.util.Stack;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.util.ISO9075;

public class XMLWriter {
    private boolean nsWritten;
    private SessionImpl session;
    private StringBuffer buffer = new StringBuffer();
    private Stack nodes;

    public XMLWriter(SessionImpl session) {
        this.session = session;
        this.nodes = new Stack();
        this.nsWritten = false;
        String enc = System.getProperty("file.encoding");
        this.buffer.append("<?xml version=\"1.0\" encoding=\"" + enc + "\"?>");
    }

    public void startElement(JCRName jcrName, Properties attrs) throws RepositoryException {
        InternalQName internalNodeName = ISO9075.encode(jcrName.getInternalName());
        String nodeName = this.session.getLocationFactory().createJCRName(internalNodeName).getAsString();
        if (nodeName.length() <= 0) {
            nodeName = "jcr:root";
        }
        this.buffer.append("<" + nodeName);
        if (!this.nsWritten) {
            this.writeNamespaces();
        }
        if (attrs != null) {
            for (String string : attrs.keySet()) {
                String propName = ISO9075.encode(string);
                String value = (String)attrs.get(string);
                this.writeAttribute(propName, value);
            }
        }
        if (!this.nodes.empty()) {
            ((Context)this.nodes.peek()).isOpen = false;
        }
        this.nodes.push(new Context(nodeName));
        this.buffer.append(">");
    }

    public void endElement() {
        if (this.nodes.empty()) {
            throw new RuntimeException("Unexpected Empty Stack at End element !!");
        }
        Context curNode = (Context)this.nodes.pop();
        this.buffer.append("</" + curNode.nodeName + ">");
    }

    private void writeAttribute(String qname, String value) {
        this.buffer.append(" " + qname + "=\"" + value + "\"");
    }

    private void writeNamespaces() throws RepositoryException {
        String[] keys = this.session.getAllNamespacePrefixes();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].length() <= 0 || keys[i].equals("xml")) continue;
            this.writeAttribute("xmlns:" + keys[i], this.session.getNamespaceURIByPrefix(keys[i]));
        }
        this.nsWritten = true;
    }

    public void writeText(String text) {
        this.buffer.append(text);
    }

    public byte[] getBytes() {
        return this.buffer.toString().getBytes();
    }

    public String toString() {
        return this.buffer.toString();
    }

    private class Context {
        private String nodeName;
        private boolean isOpen;

        private Context(String nodeName) {
            this.nodeName = nodeName;
            this.isOpen = true;
        }
    }
}

