/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.impl.server;

import java.rmi.RemoteException;
import javax.jcr.Item;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteProperty;
import org.exoplatform.services.jcr.rmi.api.remote.nodetype.RemotePropertyDefinition;
import org.exoplatform.services.jcr.rmi.api.value.SerialValueFactory;
import org.exoplatform.services.jcr.rmi.impl.server.ServerItem;

public class ServerProperty
extends ServerItem
implements RemoteProperty {
    private static final long serialVersionUID = -6718443462911336325L;
    private Property property;

    public ServerProperty(Property property, RemoteAdapterFactory factory) throws RemoteException {
        super((Item)property, factory);
        this.property = property;
    }

    public Value getValue() throws RepositoryException, RemoteException {
        try {
            return SerialValueFactory.makeSerialValue((Value)this.property.getValue());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public Value[] getValues() throws RepositoryException, RemoteException {
        try {
            return SerialValueFactory.makeSerialValueArray((Value[])this.property.getValues());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void setValue(Value value) throws RepositoryException, RemoteException {
        try {
            this.property.setValue(value);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void setValue(Value[] values) throws RepositoryException, RemoteException {
        try {
            this.property.setValue(values);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public long getLength() throws RepositoryException, RemoteException {
        try {
            return this.property.getLength();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public long[] getLengths() throws RepositoryException, RemoteException {
        try {
            return this.property.getLengths();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemotePropertyDefinition getDefinition() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemotePropertyDefinition(this.property.getDefinition());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public int getType() throws RepositoryException, RemoteException {
        try {
            return this.property.getType();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }
}

