/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.property.WebDavProperty;
import org.exoplatform.services.webdav.property.factory.MappingTable;
import org.exoplatform.services.webdav.property.factory.PropertyConfigTable;
import org.exoplatform.services.webdav.property.factory.PropertyMapping;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.response.Href;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CommonProp
implements WebDavProperty {
    private static Log log = ExoLogger.getLogger((String)"jcr.CommonProp");
    protected Href resourceHref;
    protected String propertyName = "";
    protected boolean isMultiValue = false;
    protected ArrayList<String> propertyValues = new ArrayList();
    protected String propertyValue = "";
    protected boolean isWebDavProperty = false;
    protected int status = 404;
    protected Element propertyElement;
    protected MappingTable mappingTable;
    protected PropertyConfigTable propertyConfigTable;

    public CommonProp(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setConfiguration(MappingTable mappingTable, PropertyConfigTable propertyConfigTable) {
        this.mappingTable = mappingTable;
        this.propertyConfigTable = propertyConfigTable;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getName() {
        return this.propertyName;
    }

    public void setValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    public String getValue() {
        return this.propertyValue;
    }

    public void setIsMultiValue() {
        this.isMultiValue = true;
        this.propertyValues = new ArrayList();
    }

    public boolean isMultiValue() {
        return this.isMultiValue;
    }

    public void addMultiValue(String propertyValue) {
        this.propertyValues.add(propertyValue);
    }

    protected Node getResourceNode(DavResource resource) throws RepositoryException {
        Node node = ((AbstractNodeResource)resource).getNode();
        if (node.isNodeType("nt:version")) {
            node = node.getNode("jcr:frozenNode");
        }
        PropertyMapping mapping = this.mappingTable.getMapping(this.propertyName, resource);
        String childNodeName = null;
        if (mapping != null && (childNodeName = mapping.getChildNodeName()) != null) {
            node = node.getNode(childNodeName);
        }
        return node;
    }

    protected String getJcrPropertyName(DavResource resource) throws RepositoryException {
        PropertyMapping mapping = this.mappingTable.getMapping(this.propertyName, resource);
        String mappedName = null;
        if (mapping != null) {
            mappedName = mapping.getMappedName();
        }
        if (mappedName == null) {
            return this.propertyName;
        }
        return mappedName;
    }

    protected void setValues(Node node, String jcrPropertyName) throws RepositoryException {
        String[] values = null;
        if (this.isMultiValue) {
            values = new String[this.propertyValues.size()];
            for (int i = 0; i < this.propertyValues.size(); ++i) {
                values[i] = this.propertyValues.get(i);
            }
        } else {
            values = new String[]{this.propertyValue};
        }
        node.setProperty(jcrPropertyName, values);
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        String jcrPropertyName;
        if (!(resource instanceof AbstractNodeResource)) {
            return false;
        }
        Node node = this.getResourceNode(resource);
        Property property = node.getProperty(jcrPropertyName = this.getJcrPropertyName(resource));
        if (property.getDefinition().isMultiple()) {
            this.isMultiValue = true;
            Value[] values = property.getValues();
            for (int i = 0; i < values.length; ++i) {
                Value pValue = values[i];
                this.propertyValues.add(pValue.getString());
            }
        } else {
            this.propertyValue = property.getString();
        }
        this.status = 200;
        return true;
    }

    public boolean refresh123(DavResource resource, Href href) {
        this.resourceHref = href;
        try {
            if (this.propertyConfigTable.isNeedExclude(resource, this)) {
                this.status = 406;
                return false;
            }
            boolean boolStatus = this.initialize(resource);
            return boolStatus;
        }
        catch (RepositoryException repositoryException) {
            return false;
        }
    }

    public boolean set(DavResource resource) {
        if (!(resource instanceof AbstractNodeResource)) {
            this.status = 403;
            return false;
        }
        try {
            Node node = this.getResourceNode(resource);
            String jcrPropertyName = this.getJcrPropertyName(resource);
            if (this.isMultiValue) {
                this.setValues(node, jcrPropertyName);
            } else {
                try {
                    node.setProperty(jcrPropertyName, this.propertyValue);
                }
                catch (ValueFormatException vexc) {
                    this.setValues(node, jcrPropertyName);
                }
            }
            node.getSession().save();
            this.status = 200;
            return true;
        }
        catch (Exception exception) {
            this.status = 500;
            return false;
        }
    }

    public boolean remove(DavResource resource) {
        if (!(resource instanceof AbstractNodeResource)) {
            this.status = 403;
            return false;
        }
        try {
            Node node = this.getResourceNode(resource);
            String jcrPropertyName = this.getJcrPropertyName(resource);
            Property property = node.getProperty(jcrPropertyName);
            property.remove();
            node.getSession().save();
            this.status = 200;
            return true;
        }
        catch (RepositoryException repositoryException) {
            this.status = 500;
            return false;
        }
    }

    protected void serialize(Document rootDoc, Element parentElement, String prefixedName) {
        String elementName = prefixedName;
        if (elementName.startsWith("DAV:")) {
            elementName = "D:" + elementName.substring("DAV:".length());
        }
        if (this.isMultiValue) {
            for (int i = 0; i < this.propertyValues.size(); ++i) {
                this.propertyElement = rootDoc.createElement(elementName);
                parentElement.appendChild(this.propertyElement);
                if (200 != this.status) {
                    return;
                }
                this.propertyElement.setTextContent(this.propertyValues.get(i));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)(">> property name: [" + elementName + "]"));
            }
            this.propertyElement = rootDoc.createElement(elementName);
            parentElement.appendChild(this.propertyElement);
            if (200 != this.status) {
                return;
            }
            if (!"".equals(this.propertyValue)) {
                this.propertyElement.setTextContent(this.propertyValue);
            }
        }
    }

    public void serialize(Document rootDoc, Element parentElement) {
        this.serialize(rootDoc, parentElement, this.propertyName);
    }
}

