/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.dav;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.exoplatform.services.webdav.property.dav.AbstractDAVProperty;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CheckedInProp
extends AbstractDAVProperty {
    protected String lastVersionHref = "";

    public CheckedInProp() {
        super("checked-in");
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        if (!(resource instanceof AbstractNodeResource)) {
            return false;
        }
        Node node = ((AbstractNodeResource)resource).getNode();
        if (node instanceof Version) {
            this.lastVersionHref = this.resourceHref + "?VERSIONID=" + node.getName();
            this.status = 200;
            return true;
        }
        if (node.isCheckedOut()) {
            return false;
        }
        this.lastVersionHref = this.resourceHref + "?VERSIONID=" + node.getBaseVersion().getName();
        this.status = 200;
        return true;
    }

    public void serialize(Document rootDoc, Element parentElement) {
        super.serialize(rootDoc, parentElement);
        if (this.status != 200) {
            return;
        }
        Element elHref = rootDoc.createElement("D:href");
        this.propertyElement.appendChild(elHref);
        elHref.setTextContent(this.lastVersionHref);
    }
}

