/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.dav;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.property.dav.AbstractDAVProperty;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContentTypeProp
extends AbstractDAVProperty {
    protected String mimeType = "";

    public ContentTypeProp() {
        super("getcontenttype");
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        Node contentNode;
        if (!(resource instanceof AbstractNodeResource)) {
            return false;
        }
        Node node = ((AbstractNodeResource)resource).getNode();
        if (node.isNodeType("nt:version")) {
            node = node.getNode("jcr:frozenNode");
        }
        if (!(contentNode = node.getNode("jcr:content")).hasProperty("jcr:mimeType")) {
            return false;
        }
        this.mimeType = contentNode.getProperty("jcr:mimeType").getString();
        this.status = 200;
        return true;
    }

    public void serialize(Document rootDoc, Element parentElement) {
        super.serialize(rootDoc, parentElement);
        if (this.status != 200) {
            return;
        }
        this.propertyElement.setTextContent(this.mimeType);
    }
}

