/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.dav;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.property.dav.AbstractDAVProperty;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.WorkspaceResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DisplayNameProp
extends AbstractDAVProperty {
    protected String displayName = "";

    public DisplayNameProp() {
        super("displayname");
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        if (resource instanceof WorkspaceResource) {
            this.displayName = ((WorkspaceResource)resource).getWorkspaceName();
            this.status = 200;
            return true;
        }
        if (!(resource instanceof AbstractNodeResource)) {
            return false;
        }
        Node node = ((AbstractNodeResource)resource).getNode();
        this.displayName = node.getName();
        this.status = 200;
        return true;
    }

    public void serialize(Document rootDoc, Element parentElement) {
        super.serialize(rootDoc, parentElement);
        if (this.status != 200) {
            return;
        }
        this.propertyElement.setTextContent(this.displayName);
    }
}

