/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.dav;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.property.dav.AbstractDAVProperty;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HasChildrenProp
extends AbstractDAVProperty {
    private boolean hasChildrens = true;

    public HasChildrenProp() {
        super("haschildren");
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        this.status = 200;
        if (!(resource instanceof AbstractNodeResource)) {
            return true;
        }
        Node node = ((AbstractNodeResource)resource).getNode();
        if (node.isNodeType("nt:file")) {
            this.hasChildrens = false;
            return false;
        }
        if (!node.hasNodes()) {
            this.hasChildrens = false;
        }
        return true;
    }

    public void serialize(Document rootDoc, Element parentElement) {
        this.propertyValue = this.hasChildrens ? "1" : "0";
        super.serialize(rootDoc, parentElement);
    }
}

