/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.dav;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.exoplatform.services.webdav.property.dav.AbstractDAVProperty;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.VersionResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PredecessorSet
extends AbstractDAVProperty {
    private ArrayList<String> versionPredecessors = new ArrayList();

    public PredecessorSet() {
        super("predecessor-set");
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        if (!(resource instanceof VersionResource)) {
            return false;
        }
        Node node = ((VersionResource)resource).getNode();
        Version[] predecessors = ((Version)node).getPredecessors();
        while (predecessors.length > 0 && !"jcr:rootVersion".equals(predecessors[0].getName())) {
            this.versionPredecessors.add(this.resourceHref + "?VERSIONID=" + predecessors[0].getName());
            predecessors = predecessors[0].getPredecessors();
        }
        this.status = 200;
        return true;
    }

    public void serialize(Document rootDoc, Element parentElement) {
        super.serialize(rootDoc, parentElement);
        if (this.status != 200) {
            return;
        }
        for (int i = 0; i < this.versionPredecessors.size(); ++i) {
            Element hrefEl = rootDoc.createElement("D:href");
            this.propertyElement.appendChild(hrefEl);
            hrefEl.setTextContent(this.versionPredecessors.get(i));
        }
    }
}

