/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.factory;

import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.property.CommonProp;
import org.exoplatform.services.webdav.property.WebDavProperty;
import org.exoplatform.services.webdav.property.factory.MappingTable;
import org.exoplatform.services.webdav.property.factory.PropertyConfigTable;
import org.exoplatform.services.webdav.property.factory.PropertyFactory;
import org.exoplatform.services.webdav.resource.DavResource;

public class PropertyDefine {
    private static Log log = ExoLogger.getLogger((String)"jcr.PropertyDefine");
    private String propertyNameSpace;
    private String propertyName;
    private MappingTable mapping;
    private PropertyConfigTable configTable;

    public PropertyDefine(String propertyNameSpace, String propertyName, MappingTable mapping, PropertyConfigTable configTable) {
        this.propertyNameSpace = propertyNameSpace;
        this.propertyName = propertyName;
        this.mapping = mapping;
        this.configTable = configTable;
    }

    public boolean isNeedExclude(DavResource resource) throws RepositoryException {
        return this.configTable.isNeedExclude(resource, this.propertyNameSpace + this.propertyName);
    }

    public WebDavProperty getProperty() {
        try {
            WebDavProperty property = null;
            if (this.propertyNameSpace.equalsIgnoreCase("DAV:")) {
                for (int i = 0; i < PropertyFactory.PROPERTIES.length; ++i) {
                    if (!this.propertyName.equalsIgnoreCase(PropertyFactory.PROPERTIES[i][0])) continue;
                    property = (WebDavProperty)Class.forName(PropertyFactory.PROPERTIES[i][1]).newInstance();
                    break;
                }
            }
            if (property == null) {
                property = new CommonProp(this.propertyNameSpace + this.propertyName);
            }
            property.setConfiguration(this.mapping, this.configTable);
            return property;
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            return null;
        }
    }
}

