/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.factory;

import java.util.ArrayList;
import org.exoplatform.services.webdav.property.dav.CheckedInProp;
import org.exoplatform.services.webdav.property.dav.CheckedOutProp;
import org.exoplatform.services.webdav.property.dav.ChildCountProp;
import org.exoplatform.services.webdav.property.dav.ContentLengthProp;
import org.exoplatform.services.webdav.property.dav.CreationDateProp;
import org.exoplatform.services.webdav.property.dav.DisplayNameProp;
import org.exoplatform.services.webdav.property.dav.HasChildrenProp;
import org.exoplatform.services.webdav.property.dav.IsCollectionProp;
import org.exoplatform.services.webdav.property.dav.IsFolderProp;
import org.exoplatform.services.webdav.property.dav.IsRootProp;
import org.exoplatform.services.webdav.property.dav.IsVersioned;
import org.exoplatform.services.webdav.property.dav.LastModifiedProp;
import org.exoplatform.services.webdav.property.dav.LockDiscoveryProp;
import org.exoplatform.services.webdav.property.dav.ParentNameProp;
import org.exoplatform.services.webdav.property.dav.PredecessorSet;
import org.exoplatform.services.webdav.property.dav.ResourceTypeProp;
import org.exoplatform.services.webdav.property.dav.SuccessorSetProp;
import org.exoplatform.services.webdav.property.dav.SupportedLockProp;
import org.exoplatform.services.webdav.property.dav.SupportedMethodSetProp;
import org.exoplatform.services.webdav.property.dav.SupportedQueryGrammarSetProp;
import org.exoplatform.services.webdav.property.dav.VersionHistoryProp;
import org.exoplatform.services.webdav.property.dav.VersionNameProp;
import org.exoplatform.services.webdav.property.factory.MappingTable;
import org.exoplatform.services.webdav.property.factory.PropertyConfigTable;
import org.exoplatform.services.webdav.property.factory.PropertyDefine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFactory {
    private MappingTable mappingTable;
    private PropertyConfigTable configTable;
    public static final String[][] PROPERTIES = new String[][]{{"checked-in", CheckedInProp.class.getCanonicalName()}, {"checked-out", CheckedOutProp.class.getCanonicalName()}, {"creationdate", CreationDateProp.class.getCanonicalName()}, {"displayname", DisplayNameProp.class.getCanonicalName()}, {"getcontentlength", ContentLengthProp.class.getCanonicalName()}, {"getlastmodified", LastModifiedProp.class.getCanonicalName()}, {"iscollection", IsCollectionProp.class.getCanonicalName()}, {"lockdiscovery", LockDiscoveryProp.class.getCanonicalName()}, {"predecessor-set", PredecessorSet.class.getCanonicalName()}, {"resourcetype", ResourceTypeProp.class.getCanonicalName()}, {"successor-set", SuccessorSetProp.class.getCanonicalName()}, {"supportedlock", SupportedLockProp.class.getCanonicalName()}, {"version-history", VersionHistoryProp.class.getCanonicalName()}, {"version-name", VersionNameProp.class.getCanonicalName()}, {"supported-query-grammar-set", SupportedQueryGrammarSetProp.class.getCanonicalName()}, {"supported-method-set", SupportedMethodSetProp.class.getCanonicalName()}, {"parentname", ParentNameProp.class.getCanonicalName()}, {"isroot", IsRootProp.class.getCanonicalName()}, {"isversioned", IsVersioned.class.getCanonicalName()}, {"haschildren", HasChildrenProp.class.getCanonicalName()}, {"childcount", ChildCountProp.class.getCanonicalName()}, {"isfolder", IsFolderProp.class.getCanonicalName()}};

    public PropertyFactory(MappingTable mappingTable, PropertyConfigTable configTable) {
        this.mappingTable = mappingTable;
        this.configTable = configTable;
    }

    public PropertyDefine getDefine(String propertyNameSpace, String propertyName) {
        return new PropertyDefine(propertyNameSpace, propertyName, this.mappingTable, this.configTable);
    }

    public ArrayList<PropertyDefine> getDefines(String nodeTypeName) {
        ArrayList<PropertyDefine> defines = new ArrayList<PropertyDefine>();
        ArrayList<String> includes = this.configTable.getIncludes(nodeTypeName);
        for (int i = 0; i < includes.size(); ++i) {
            String curPropertyName = includes.get(i);
            int pos = curPropertyName.indexOf(":");
            if (pos > 0) {
                String propertyNameSpace = curPropertyName.substring(0, pos + 1);
                String propertyName = curPropertyName.substring(pos + 1);
                defines.add(this.getDefine(propertyNameSpace, propertyName));
                continue;
            }
            defines.add(this.getDefine("DAV:", curPropertyName));
        }
        return defines;
    }
}

