/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.request.documents;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.DavUtil;
import org.exoplatform.services.webdav.property.WebDavProperty;
import org.exoplatform.services.webdav.property.factory.PropertyDefine;
import org.exoplatform.services.webdav.property.factory.PropertyFactory;
import org.exoplatform.services.webdav.request.documents.RequestDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUpdateDoc
implements RequestDocument {
    private static Log log = ExoLogger.getLogger((String)"jcr.PropertyUpdateDoc");
    private HashMap<String, WebDavProperty> setList = new HashMap();
    private ArrayList<WebDavProperty> removeList = new ArrayList();

    @Override
    public boolean init(Document requestDocument, PropertyFactory propertyFactory) {
        try {
            Node nodeRemove;
            WebDavProperty property;
            PropertyDefine define;
            String localName;
            String nameSpace;
            Node propertyUpdate = DavUtil.getChildNode(requestDocument, "propertyupdate");
            Node nodeSet = DavUtil.getChildNode(propertyUpdate, "set");
            if (nodeSet != null) {
                Node nodeProp = DavUtil.getChildNode(nodeSet, "prop");
                NodeList nodes = nodeProp.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node curNode = nodes.item(i);
                    String textContent = curNode.getTextContent();
                    nameSpace = curNode.getNamespaceURI();
                    localName = curNode.getLocalName();
                    if (this.setList.containsKey(nameSpace + localName)) {
                        WebDavProperty property2 = this.setList.get(nameSpace + localName);
                        if (!property2.isMultiValue()) {
                            property2.setIsMultiValue();
                            property2.addMultiValue(property2.getValue());
                        }
                        property2.addMultiValue(textContent);
                        continue;
                    }
                    define = propertyFactory.getDefine(nameSpace, localName);
                    property = define.getProperty();
                    property.setValue(textContent);
                    this.setList.put(nameSpace + localName, property);
                }
            }
            if ((nodeRemove = DavUtil.getChildNode(propertyUpdate, "remove")) != null) {
                Node nodeProp = DavUtil.getChildNode(nodeRemove, "prop");
                NodeList nodes = nodeProp.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node curNode = nodes.item(i);
                    nameSpace = curNode.getNamespaceURI();
                    localName = curNode.getLocalName();
                    define = propertyFactory.getDefine(nameSpace, localName);
                    property = define.getProperty();
                    this.removeList.add(property);
                }
            }
            return true;
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            return false;
        }
    }

    public HashMap<String, WebDavProperty> getSetList() {
        return this.setList;
    }

    public ArrayList<WebDavProperty> getRemoveList() {
        return this.removeList;
    }
}

