/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.resource;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.exoplatform.services.webdav.WebDavCommandContext;
import org.exoplatform.services.webdav.request.documents.CommonPropDoc;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.VersionResource;
import org.exoplatform.services.webdav.response.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaVResource
extends AbstractNodeResource {
    public DeltaVResource(WebDavCommandContext context, Node node) throws RepositoryException {
        super(context, node);
    }

    public ArrayList<DavResource> getChildsVersions() throws RepositoryException {
        ArrayList<DavResource> resources = new ArrayList<DavResource>();
        VersionHistory vHistory = this.getNode().getVersionHistory();
        VersionIterator vIter = vHistory.getAllVersions();
        while (vIter.hasNext()) {
            Version version = vIter.nextVersion();
            if ("jcr:rootVersion".equals(version.getName())) continue;
            VersionResource resource = new VersionResource(this.context, version, this);
            resources.add(resource);
        }
        return resources;
    }

    public ArrayList<Response> getVersionResponces(CommonPropDoc reqProps, int depth) throws RepositoryException {
        ArrayList<Response> responses = new ArrayList<Response>();
        ArrayList<DavResource> versions = this.getChildsVersions();
        for (int i = 0; i < versions.size(); ++i) {
            Response response = versions.get(i).getResponse(reqProps);
            if (response == null) continue;
            responses.add(response);
        }
        return responses;
    }
}

