/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.resource;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.webdav.WebDavCommandContext;
import org.exoplatform.services.webdav.request.documents.CommonPropDoc;
import org.exoplatform.services.webdav.resource.DavCommonResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.DavResourceInfo;
import org.exoplatform.services.webdav.resource.DavResourceInfoImpl;
import org.exoplatform.services.webdav.resource.NodeResource;
import org.exoplatform.services.webdav.response.Href;
import org.exoplatform.services.webdav.response.Response;
import org.exoplatform.services.webdav.response.ResponseImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceResource
extends DavCommonResource {
    private String workspaceName;

    public WorkspaceResource(WebDavCommandContext context, String workspaceName) {
        super(context);
        this.workspaceName = workspaceName;
    }

    @Override
    public boolean isCollection() throws RepositoryException {
        return true;
    }

    @Override
    public String getName() throws RepositoryException {
        return this.workspaceName;
    }

    @Override
    public DavResourceInfo getInfo() throws RepositoryException {
        DavResourceInfoImpl info = new DavResourceInfoImpl();
        info.setName(this.workspaceName);
        info.setContentStream(new ByteArrayInputStream("".getBytes()));
        return info;
    }

    @Override
    public Session getSession() throws RepositoryException {
        return this.context.getWebDavRequest().getSession(this.context.getSessionProvider(), this.workspaceName);
    }

    @Override
    public Response getResponse(CommonPropDoc reqProps) throws RepositoryException {
        ResponseImpl response = new ResponseImpl();
        Href href = new Href(this.context, "/" + this.workspaceName);
        response.setHref(href);
        this.initResponse(reqProps, response);
        return response;
    }

    @Override
    public ArrayList<DavResource> getChildsResources() throws RepositoryException {
        Session session = this.getSession();
        Node rootNode = session.getRootNode();
        ArrayList<DavResource> childs = new ArrayList<DavResource>();
        NodeIterator nodeIter = rootNode.getNodes();
        while (nodeIter.hasNext()) {
            Node curNode = nodeIter.nextNode();
            childs.add(new NodeResource(this.context, curNode));
        }
        return childs;
    }

    @Override
    public int getChildCount() throws RepositoryException {
        Session session = this.getSession();
        return (int)session.getRootNode().getNodes().getSize();
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }
}

