/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.resource.searchable;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.webdav.WebDavCommandContext;
import org.exoplatform.services.webdav.request.documents.PropFindDoc;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.NodeResource;
import org.exoplatform.services.webdav.resource.searchable.SearchableResource;
import org.exoplatform.services.webdav.response.Response;
import org.exoplatform.services.webdav.search.Search;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchableNode
extends AbstractNodeResource
implements SearchableResource {
    private String searchablePath;

    public SearchableNode(WebDavCommandContext context, Node node) throws RepositoryException {
        super(context, node);
        this.searchablePath = context.getWebDavRequest().getSrcPath();
        if (!this.searchablePath.endsWith("/")) {
            this.searchablePath = this.searchablePath + "/";
        }
    }

    @Override
    public ArrayList<Response> doSearch(Search search) throws RepositoryException {
        QueryManager queryManager = null;
        try {
            queryManager = this.getNode().getSession().getWorkspace().getQueryManager();
        }
        catch (RepositoryException rexc) {
            rexc.printStackTrace();
            return new ArrayList<Response>();
        }
        Query query = queryManager.createQuery(search.getQuery(), search.getQueryLanguage());
        QueryResult result = query.execute();
        NodeIterator nodeIter = result.getNodes();
        PropFindDoc propFindDoc = new PropFindDoc();
        propFindDoc.initFactory(this.context.getWebDavRequest().getPropertyFactory());
        ArrayList<Response> responses = new ArrayList<Response>();
        while (nodeIter.hasNext()) {
            Node curNode = nodeIter.nextNode();
            if (!this.isSameNode(curNode)) continue;
            if ("jcr:content".equals(curNode.getName()) && curNode.getParent().isNodeType("nt:file")) {
                curNode = curNode.getParent();
            }
            NodeResource resource = new NodeResource(this.context, curNode);
            responses.add(resource.getResponse(propFindDoc));
        }
        return responses;
    }

    private boolean isSameNode(Node node) throws RepositoryException {
        return node.getPath().startsWith(this.searchablePath);
    }
}

