/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.response;

import java.util.Hashtable;

public class DavStatus {
    public static final int CONTINUE = 100;
    public static final int SWITCHING_PROTOCOLS = 101;
    public static final int OK = 200;
    public static final int CREATED = 201;
    public static final int ACCEPTED = 202;
    public static final int NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int NO_CONTENT = 204;
    public static final int RESET_CONTENT = 205;
    public static final int PARTIAL_CONTENT = 206;
    public static final int MULTISTATUS = 207;
    public static final int MULTIPLE_CHOICES = 300;
    public static final int MOVED_PERMANENTLY = 301;
    public static final int FOUND = 302;
    public static final int SEE_OTHER = 303;
    public static final int NOT_MODIFIED = 304;
    public static final int USE_PROXY = 305;
    public static final int TEMPORARY_REDIRECT = 307;
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int PAYMENT_REQUIRED = 402;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int METHOD_NOT_ALLOWED = 405;
    public static final int NOT_ACCEPTABLE = 406;
    public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int REQUEST_TIMEOUT = 408;
    public static final int CONFLICT = 409;
    public static final int GONE = 410;
    public static final int LENGTH_REQUIRED = 411;
    public static final int PRECONDITION_FAILED = 412;
    public static final int REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int REQUEST_URI_TOO_LONG = 414;
    public static final int UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int EXPECTATION_FAILED = 417;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int NOT_IMPLEMENTED = 501;
    public static final int BAD_GATEWAY = 502;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final int GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION_NOT_SUPPORTED = 505;
    private static Hashtable<Integer, String> statusDescriptions = new Hashtable();

    private static void registerDescr(int status, String descr) {
        statusDescriptions.put(new Integer(status), descr);
    }

    public static final String getStatusDescription(int status) {
        String description = "";
        Integer statusKey = new Integer(status);
        if (statusDescriptions.containsKey(statusKey)) {
            description = statusDescriptions.get(statusKey);
        }
        return String.format("%s %d %s", "HTTP/1.1", status, description);
    }

    static {
        DavStatus.registerDescr(100, "Continue");
        DavStatus.registerDescr(101, "Switching Protocols");
        DavStatus.registerDescr(200, "OK");
        DavStatus.registerDescr(201, "Created");
        DavStatus.registerDescr(202, "Accepted");
        DavStatus.registerDescr(203, "Non-Authoritative Information");
        DavStatus.registerDescr(204, "No Content");
        DavStatus.registerDescr(205, "Reset Content");
        DavStatus.registerDescr(206, "Partial Content");
        DavStatus.registerDescr(207, "Multi Status");
        DavStatus.registerDescr(300, "Multiple Choices");
        DavStatus.registerDescr(301, "Moved Permanently");
        DavStatus.registerDescr(302, "Found");
        DavStatus.registerDescr(303, "See Other");
        DavStatus.registerDescr(304, "Not Modified");
        DavStatus.registerDescr(305, "Use Proxy");
        DavStatus.registerDescr(307, "Temporary Redirect");
        DavStatus.registerDescr(400, "Bad Request");
        DavStatus.registerDescr(401, "Unauthorized");
        DavStatus.registerDescr(402, "Payment Required");
        DavStatus.registerDescr(403, "Forbidden");
        DavStatus.registerDescr(404, "Not Found");
        DavStatus.registerDescr(405, "Method Not Allowed");
        DavStatus.registerDescr(406, "Not Acceptable");
        DavStatus.registerDescr(407, "Proxy Authentication Required");
        DavStatus.registerDescr(408, "Request Timeout");
        DavStatus.registerDescr(409, "Conflict");
        DavStatus.registerDescr(410, "Gone");
        DavStatus.registerDescr(411, "Length Required");
        DavStatus.registerDescr(412, "Precondition Failed");
        DavStatus.registerDescr(413, "Request Entity Too Large");
        DavStatus.registerDescr(414, "Request-URI Too Long");
        DavStatus.registerDescr(415, "Unsupported Media Type");
        DavStatus.registerDescr(416, "Requested Range Not Satisfiable");
        DavStatus.registerDescr(417, "Expectation Failed");
        DavStatus.registerDescr(500, "Internal Server Error");
        DavStatus.registerDescr(501, "Not Implemented");
        DavStatus.registerDescr(502, "Bad Gateway");
        DavStatus.registerDescr(503, "Service Unavailable");
        DavStatus.registerDescr(504, "Gateway Timeout");
        DavStatus.registerDescr(505, "HTTP Version Not Supported");
    }
}

