/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.search.basicsearch;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.DavUtil;
import org.exoplatform.services.webdav.search.Search;
import org.exoplatform.services.webdav.search.basicsearch.convertor.DASLConvertor;
import org.exoplatform.services.webdav.search.basicsearch.convertor.DASLTag;
import org.exoplatform.services.webdav.search.basicsearch.convertor.SaxValidator;
import org.exoplatform.services.webdav.search.basicsearch.convertor.dasl.DASLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSearch
implements Search {
    private static Log log = ExoLogger.getLogger((String)"jcr.BasicSearch");
    private String query;

    @Override
    public boolean init(Node node) {
        try {
            Node selectNode = DavUtil.getChildNode(node, "select");
            log.info((Object)("SELECT NODE: " + selectNode));
            Node allPropNode = DavUtil.getChildNode(selectNode, "allprop");
            if (allPropNode != null) {
                log.info((Object)"REQUIRED ALL PROPERTIES..........");
            } else {
                Node propNode = DavUtil.getChildNode(selectNode, "prop");
                NodeList propertyNodes = propNode.getChildNodes();
                for (int i = 0; i < propertyNodes.getLength(); ++i) {
                    Node curNode = propertyNodes.item(i);
                    log.info((Object)"----------------------------");
                    log.info((Object)("NAMESPACE: " + curNode.getNamespaceURI()));
                    log.info((Object)("LOCALNAME: " + curNode.getLocalName()));
                }
            }
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
        Vector<String> nodeTypes = new Vector<String>();
        nodeTypes.add("nt:base");
        try {
            String searchRequestStr = this.getSerializedSearchRequest(node);
            DASLTag parser = new DASLTag(new StringReader(searchRequestStr));
            DASLDocument doc = parser.DASLDocument();
            DASLConvertor dc = new DASLConvertor(nodeTypes);
            dc.setFromElements(nodeTypes);
            SaxValidator sv = new SaxValidator(searchRequestStr);
            sv.validate();
            dc.setDASLPrefix(sv.getDASLPrefix());
            this.query = dc.convertQuery(doc);
            return true;
        }
        catch (Throwable exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), exc);
            return false;
        }
    }

    private String getSerializedSearchRequest(Node node) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Document document = node.getOwnerDocument();
        OutputFormat format = new OutputFormat("xml", "UTF-8", true);
        XMLSerializer serializer = new XMLSerializer((OutputStream)out, format);
        serializer.setNamespaces(true);
        serializer.asDOMSerializer().serialize(document);
        return new String(out.toByteArray());
    }

    @Override
    public String getQueryLanguage() {
        return "sql";
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public Vector<String> getRequiredPropertyList() {
        return new Vector<String>();
    }
}

