/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class CalendarUtil {
    public static int getDaysInMonth(Date date) {
        int days = 0;
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        int month = gc.get(2) + 1;
        int year = gc.get(1);
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            days = 31;
        } else if (month == 4 || month == 6 || month == 9 || month == 11) {
            days = 30;
        } else if (month == 2) {
            days = CalendarUtil.isLeapYear(year) ? 29 : 28;
        }
        return days;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static int getWeekOfDay(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        return c.get(7);
    }

    public static int compareDate(GregorianCalendar gCal1, GregorianCalendar gCal2) {
        if (gCal1.get(1) < gCal2.get(1)) {
            return -1;
        }
        if (gCal1.get(1) > gCal2.get(1)) {
            return 1;
        }
        if (gCal1.get(2) < gCal2.get(2)) {
            return -1;
        }
        if (gCal1.get(2) > gCal2.get(2)) {
            return 1;
        }
        if (gCal1.get(5) < gCal2.get(5)) {
            return -1;
        }
        if (gCal1.get(5) > gCal2.get(5)) {
            return 1;
        }
        return 0;
    }

    public static int compareTimeUpToMinute(GregorianCalendar gCal1, GregorianCalendar gCal2) {
        if (gCal1.get(11) < gCal2.get(11)) {
            return -1;
        }
        if (gCal1.get(11) > gCal2.get(11)) {
            return 1;
        }
        if (gCal1.get(12) < gCal2.get(12)) {
            return -1;
        }
        if (gCal1.get(12) > gCal2.get(12)) {
            return 1;
        }
        return 0;
    }

    public static int compareDateTimeUpToMinute(GregorianCalendar gCal1, GregorianCalendar gCal2) {
        if (CalendarUtil.compareDate(gCal1, gCal2) < 0) {
            return -1;
        }
        if (CalendarUtil.compareDate(gCal1, gCal2) > 0) {
            return 1;
        }
        if (CalendarUtil.compareTimeUpToMinute(gCal1, gCal2) < 0) {
            return -1;
        }
        if (CalendarUtil.compareTimeUpToMinute(gCal1, gCal2) > 0) {
            return 1;
        }
        return 0;
    }

    public static String format(GregorianCalendar gCal) {
        return new SimpleDateFormat().format(gCal);
    }
}

