/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.exoplatform.container.ContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentLifecyclePlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.jmx.ExoContainerMBean;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.InitParams;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DefaultPicoContainer;

public class ExoContainer
extends DefaultPicoContainer {
    private Map componentLifecylePlugin_ = new HashMap();
    private List<ContainerLifecyclePlugin> containerLifecyclePlugin_ = new ArrayList<ContainerLifecyclePlugin>();
    protected ExoContainerContext context = new ExoContainerContext(this);

    public ExoContainer(PicoContainer parent) {
        super(parent);
        this.context.setName(((Object)((Object)this)).getClass().getName());
        this.registerComponentInstance(this.context);
    }

    public ExoContainer(ComponentAdapterFactory factory, PicoContainer parent) {
        super(factory, parent);
        this.context.setName(((Object)((Object)this)).getClass().getName());
        this.registerComponentInstance(this.context);
    }

    public ExoContainerContext getContext() {
        return this.context;
    }

    public void initContainer() throws Exception {
        ConfigurationManager manager = (ConfigurationManager)this.getComponentInstanceOfType(ConfigurationManager.class);
        ContainerUtil.addContainerLifecyclePlugin(this, manager);
        ContainerUtil.addComponentLifecyclePlugin(this, manager);
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            plugin.initContainer(this);
        }
        ContainerUtil.addComponents(this, manager);
    }

    public void startContainer() throws Exception {
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            plugin.startContainer(this);
        }
    }

    public void stopContainer() throws Exception {
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            plugin.stopContainer(this);
        }
    }

    public void destroyContainer() throws Exception {
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            plugin.destroyContainer(this);
        }
    }

    public MBeanServer getMBeanServer() {
        throw new UnsupportedOperationException("This container do not support jmx management");
    }

    public void addComponentLifecylePlugin(ComponentLifecyclePlugin plugin) {
        List<String> list = plugin.getManageableComponents();
        for (String component : list) {
            this.componentLifecylePlugin_.put(component, plugin);
        }
    }

    public void addContainerLifecylePlugin(ContainerLifecyclePlugin plugin) {
        this.containerLifecyclePlugin_.add(plugin);
    }

    public Object createComponent(Class clazz) throws Exception {
        return this.createComponent(clazz, null);
    }

    public Object createComponent(Class clazz, InitParams params) throws Exception {
        Constructor[] constructors = ContainerUtil.getSortedConstructors(clazz);
        for (int k = 0; k < constructors.length; ++k) {
            Constructor constructor = constructors[k];
            Class<?>[] parameters = constructor.getParameterTypes();
            Object[] args = new Object[parameters.length];
            boolean satisfied = true;
            for (int i = 0; i < args.length; ++i) {
                if (parameters[i].equals(InitParams.class)) {
                    args[i] = params;
                    continue;
                }
                args[i] = this.getComponentInstanceOfType(parameters[i]);
                if (args[i] != null) continue;
                satisfied = false;
                break;
            }
            if (!satisfied) continue;
            return constructor.newInstance(args);
        }
        throw new Exception("Cannot find a satisfying constructor for " + clazz);
    }

    public void manageMBean(Component component, String componentKey, Object bean) {
        ObjectName name = null;
        MBeanServer mbeanServer = this.getMBeanServer();
        ExoContainerMBean mbean = null;
        try {
            name = ExoContainer.asObjectName(component, componentKey);
            mbean = new ExoContainerMBean(bean);
            mbeanServer.registerMBean(mbean, name);
        }
        catch (InstanceAlreadyExistsException e) {
            try {
                mbeanServer.unregisterMBean(name);
                mbeanServer.registerMBean(mbean, name);
            }
            catch (Exception e1) {
                throw new RuntimeException("Failed to register MBean '" + name + " due to " + e.getMessage(), e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register MBean '" + name + " due to " + e.getMessage(), e);
        }
    }

    private static ObjectName asObjectName(Component component, String componentKey) throws MalformedObjectNameException {
        String name = null;
        if (component != null && component.getJMXName() != null) {
            name = component.getJMXName();
        }
        if (name == null || name.indexOf(58) == -1) {
            name = "component:type=" + componentKey;
        }
        return new ObjectName(name);
    }

    public void printMBeanServer() {
        MBeanServer server = this.getMBeanServer();
        Set<ObjectName> names = server.queryNames(null, null);
        for (ObjectName name : names) {
            try {
                MBeanInfo info = server.getMBeanInfo(name);
                MBeanAttributeInfo[] attrs = info.getAttributes();
                if (attrs == null) continue;
                for (int j = 0; j < attrs.length; ++j) {
                    if (!attrs[j].isReadable()) continue;
                    try {
                        Object o = server.getAttribute(name, attrs[j].getName());
                        continue;
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
                MBeanOperationInfo[] methods = info.getOperations();
                for (int j = 0; j < methods.length; ++j) {
                    MBeanParameterInfo[] params = methods[j].getSignature();
                    for (int k = 0; k < params.length; ++k) {
                    }
                }
            }
            catch (Exception x) {
            }
        }
    }
}

