/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.File;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.servlet.ServletContext;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;
import org.exoplatform.container.configuration.MockConfigurationManagerImpl;
import org.exoplatform.container.jmx.MX4JComponentAdapterFactory;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.container.monitor.jvm.OperatingSystemInfo;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.test.mocks.servlet.MockServletContext;
import org.picocontainer.PicoContainer;

public class RootContainer
extends ExoContainer {
    private static RootContainer singleton_;
    private MBeanServer mbeanServer_ = MBeanServerFactory.createMBeanServer("exomx");
    private OperatingSystemInfo osenv_;
    private J2EEServerInfo serverenv_;

    public RootContainer() {
        super(new MX4JComponentAdapterFactory(), null);
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(this));
        this.serverenv_ = new J2EEServerInfo();
        this.registerComponentInstance(J2EEServerInfo.class, this.serverenv_);
    }

    public OperatingSystemInfo getOSEnvironment() {
        if (this.osenv_ == null) {
            this.osenv_ = (OperatingSystemInfo)this.getComponentInstanceOfType(OperatingSystemInfo.class);
        }
        return this.osenv_;
    }

    public J2EEServerInfo getServerEnvironment() {
        return this.serverenv_;
    }

    public PortalContainer getPortalContainer(String name) {
        J2EEServerInfo senv;
        PortalContainer pcontainer = (PortalContainer)this.getComponentInstance(name);
        if (pcontainer == null && ("standalone".equals((senv = this.getServerEnvironment()).getServerName()) || "test".equals(senv.getServerName()))) {
            try {
                MockServletContext scontext = new MockServletContext(name);
                pcontainer = new PortalContainer((PicoContainer)this, (ServletContext)scontext);
                MockConfigurationManagerImpl cService = new MockConfigurationManagerImpl((ServletContext)scontext);
                cService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/configuration.xml"));
                cService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/test-configuration.xml"));
                cService.processRemoveConfiguration();
                pcontainer.registerComponentInstance(ConfigurationManager.class, cService);
                pcontainer.initContainer();
                this.registerComponentInstance(name, pcontainer);
                PortalContainer.setInstance(pcontainer);
                ExoContainerContext.setCurrentContainer(pcontainer);
                pcontainer.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return pcontainer;
    }

    public synchronized PortalContainer createPortalContainer(ServletContext context) {
        try {
            PortalContainer pcontainer = new PortalContainer((PicoContainer)this, context);
            PortalContainer.setInstance(pcontainer);
            ExoContainerContext.setCurrentContainer(pcontainer);
            ConfigurationManagerImpl cService = new ConfigurationManagerImpl(context);
            cService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/configuration.xml"));
            try {
                cService.addConfiguration("war:/conf/configuration.xml");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            cService.processRemoveConfiguration();
            pcontainer.registerComponentInstance(ConfigurationManager.class, cService);
            pcontainer.initContainer();
            this.registerComponentInstance(context.getServletContextName(), pcontainer);
            PortalContainer.setInstance(pcontainer);
            ExoContainerContext.setCurrentContainer(pcontainer);
            pcontainer.start();
            return pcontainer;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public synchronized void removePortalContainer(ServletContext servletContext) {
        this.unregisterComponent(servletContext.getServletContextName());
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer_;
    }

    public static Object getComponent(Class key) {
        return RootContainer.getInstance().getComponentInstanceOfType(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RootContainer getInstance() {
        if (singleton_ != null) return singleton_;
        Class<RootContainer> clazz = RootContainer.class;
        synchronized (RootContainer.class) {
            if (singleton_ != null) return singleton_;
            try {
                String confDir;
                String overrideConf;
                File file;
                singleton_ = new RootContainer();
                ConfigurationManagerImpl service = new ConfigurationManagerImpl(null);
                service.addConfiguration(ContainerUtil.getConfigurationURL("conf/configuration.xml"));
                if (System.getProperty("maven.exoplatform.dir") != null) {
                    service.addConfiguration(ContainerUtil.getConfigurationURL("conf/test-configuration.xml"));
                }
                if ((file = new File(overrideConf = (confDir = singleton_.getServerEnvironment().getExoConfigurationDirectory()) + "/configuration.xml")).exists()) {
                    service.addConfiguration("file:" + overrideConf);
                }
                service.processRemoveConfiguration();
                singleton_.registerComponentInstance(ConfigurationManager.class, service);
                singleton_.initContainer();
                singleton_.start();
                ExoContainerContext.setTopContainer(singleton_);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            return singleton_;
        }
    }

    public static void setInstance(RootContainer rcontainer) {
        singleton_ = rcontainer;
    }

    public void stop() {
        super.stop();
        ExoContainerContext.setTopContainer(null);
    }

    static class ShutdownThread
    extends Thread {
        RootContainer container_;

        ShutdownThread(RootContainer container) {
            this.container_ = container;
        }

        public void run() {
            this.container_.stop();
        }
    }
}

