/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationDatabaseInitializer;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.OrganizationServiceInitializer;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;
import org.picocontainer.Startable;

public abstract class BaseOrganizationService
implements OrganizationService,
Startable {
    protected UserHandler userHandler_;
    protected UserProfileHandler userProfileHandler_;
    protected GroupHandler groupHandler_;
    protected MembershipHandler membershipHandler_;
    protected MembershipTypeHandler membershipTypeHandler_;
    protected List<OrganizationDatabaseInitializer> listeners_ = new ArrayList<OrganizationDatabaseInitializer>(3);

    public UserHandler getUserHandler() {
        return this.userHandler_;
    }

    public UserProfileHandler getUserProfileHandler() {
        return this.userProfileHandler_;
    }

    public GroupHandler getGroupHandler() {
        return this.groupHandler_;
    }

    public MembershipTypeHandler getMembershipTypeHandler() {
        return this.membershipTypeHandler_;
    }

    public MembershipHandler getMembershipHandler() {
        return this.membershipHandler_;
    }

    public void start() {
        try {
            int i = 0;
            while (i < this.listeners_.size()) {
                OrganizationServiceInitializer listener = this.listeners_.get(i);
                listener.init(this);
                ++i;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void stop() {
    }

    public synchronized void addListenerPlugin(ComponentPlugin listener) throws Exception {
        if (listener instanceof UserEventListener) {
            this.userHandler_.addUserEventListener((UserEventListener)listener);
        } else if (listener instanceof GroupEventListener) {
            this.groupHandler_.addGroupEventListener((GroupEventListener)listener);
        } else if (listener instanceof MembershipEventListener) {
            this.membershipHandler_.addMembershipEventListener((MembershipEventListener)listener);
        } else if (listener instanceof UserProfileEventListener) {
            this.userProfileHandler_.addUserProfileEventListener((UserProfileEventListener)listener);
        } else if (listener instanceof OrganizationDatabaseInitializer) {
            this.listeners_.add((OrganizationDatabaseInitializer)listener);
        } else {
            throw new RuntimeException(String.valueOf(listener.getClass().getName()) + "is an unknown listener type");
        }
    }
}

