/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.backup;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.backup.DataTransformer;
import org.exoplatform.services.backup.Metadata;
import org.exoplatform.services.backup.XMLObjectConverter;
import org.exoplatform.xml.object.XMLCollection;
import org.exoplatform.xml.object.XMLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImportExportPlugin
implements ComponentPlugin {
    public static final String DATA_VERSION = "1.0.1";
    private Map<String, XMLObjectConverter> xmlObjectTransformer_ = new HashMap<String, XMLObjectConverter>();
    private List<DataTransformer> dataTransformer_ = new ArrayList<DataTransformer>();
    private String name;
    private String description;
    private String dataVersion;

    public void init(InitParams params) throws Exception {
        List list = params.getObjectParamValues(DataTransformer.class);
        this.addDataTransformer(list);
        List list2 = params.getObjectParamValues(XMLObjectConverter.class);
        this.addXMLObjectConverter(list2);
        if (params.getValueParam("data.version") != null) {
            this.dataVersion = params.getValueParam("data.version").getValue();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public String getCurrentDataVersion() {
        return this.dataVersion;
    }

    public void setCurrentDataVersion(String s) {
        this.dataVersion = s;
    }

    public boolean hasUserData() {
        return true;
    }

    public boolean hasServiceData() {
        return true;
    }

    public void addDataTransformer(List<DataTransformer> list) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            DataTransformer transformer = list.get(i);
            transformer.init(this);
            this.dataTransformer_.add(transformer);
        }
    }

    public List<DataTransformer> getDataTransformer() {
        return this.dataTransformer_;
    }

    public void addXMLObjectConverter(List<XMLObjectConverter> list) {
        for (int i = 0; i < list.size(); ++i) {
            XMLObjectConverter transformer = list.get(i);
            this.xmlObjectTransformer_.put(transformer.getDataVersion(), transformer);
        }
    }

    public XMLObjectConverter getXMLObjectConverter(String dataVersion) {
        return this.xmlObjectTransformer_.get(dataVersion);
    }

    public abstract void exportUserData(String var1, ZipOutputStream var2) throws Exception;

    public abstract void importUserData(String var1, ZipFile var2) throws Exception;

    public void transformUserData(String user, ZipOutputStream os) throws Exception {
        for (int i = 0; i < this.dataTransformer_.size(); ++i) {
            DataTransformer transformer = this.dataTransformer_.get(i);
            transformer.transformUserData(user, os);
        }
    }

    public abstract void exportServiceData(ZipOutputStream var1) throws Exception;

    public abstract void importServiceData(ZipFile var1) throws Exception;

    public void transformServiceData(ZipOutputStream os) throws Exception {
        for (int i = 0; i < this.dataTransformer_.size(); ++i) {
            DataTransformer transformer = this.dataTransformer_.get(i);
            transformer.transformServiceData(os);
        }
    }

    public Metadata getMetadata(String name, ZipFile zipFile) throws Exception {
        Metadata mdata = (Metadata)XMLObject.getObject((InputStream)this.getEntry(name, zipFile));
        return mdata;
    }

    protected InputStream getEntry(String name, ZipFile zipFile) throws Exception {
        ZipEntry entry = zipFile.getEntry(name);
        if (entry == null) {
            return null;
        }
        return zipFile.getInputStream(entry);
    }

    protected void createEntry(String name, ZipOutputStream os, Object o) throws Exception {
        os.putNextEntry(new ZipEntry(name));
        if (o instanceof Collection) {
            XMLCollection xmlobject = new XMLCollection((Collection)o);
            os.write(xmlobject.toByteArray("UTF-8"));
        } else {
            XMLObject xmlobject = new XMLObject(o);
            os.write(xmlobject.toByteArray("UTF-8"));
        }
        os.closeEntry();
    }
}

