/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.grammar.wiki.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IntrospectionInfo {
    private static Map cacheMethod_ = new HashMap();
    String exp;
    String beanName;
    String methodName;
    List args;
    boolean error = false;

    public IntrospectionInfo(String exp) {
        int index;
        this.exp = exp;
        int start = 2;
        int length = exp.length() - 1;
        for (index = 2; index < length; ++index) {
            if (exp.charAt(index) == '.') {
                this.beanName = exp.substring(start, index);
                start = index + 1;
                break;
            }
            if (index != length - 1) continue;
            this.beanName = exp.substring(start, length);
            return;
        }
        while (index < length) {
            if (exp.charAt(index) == '(') {
                this.methodName = exp.substring(start, index);
                start = index + 1;
                break;
            }
            if (index == length - 1) {
                this.methodName = exp.substring(start, length);
                return;
            }
            ++index;
        }
        boolean openQuote = false;
        while (index < length) {
            if (exp.charAt(index) == '\"') {
                openQuote = !openQuote;
            } else if (exp.charAt(index) == ',' && !openQuote) {
                if (this.args == null) {
                    this.args = new ArrayList();
                }
                this.args.add(exp.substring(start, index));
                start = index + 1;
            } else if (index == length - 1 && exp.charAt(index) == ')') {
                String arg = exp.substring(start, index).trim();
                if (arg.length() > 0) {
                    if (this.args == null) {
                        this.args = new ArrayList();
                    }
                    this.args.add(arg);
                }
                return;
            }
            ++index;
        }
        this.error = true;
    }

    public Object invoke(Object bean) throws Exception {
        Method method = this.getMethod(bean);
        Object[] invokeArgs = null;
        Class<?>[] types = method.getParameterTypes();
        invokeArgs = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            invokeArgs[i] = this.getArgumentValue(types[i], (String)this.args.get(i));
        }
        Object ret = method.invoke(bean, invokeArgs);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getMethod(Object bean) throws Exception {
        Class<?> clazz = bean.getClass();
        String cacheKey = null;
        cacheKey = this.args != null ? clazz.getName() + "+" + this.methodName + "+" + this.args.size() : clazz.getName() + "+" + this.methodName;
        Method method = (Method)cacheMethod_.get(cacheKey);
        if (method != null) {
            return method;
        }
        Map map = cacheMethod_;
        synchronized (map) {
            if (this.args == null) {
                method = clazz.getMethod(this.methodName, null);
            } else {
                Method[] methods = clazz.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    if (!this.methodName.equals(methods[i].getName()) || methods[i].getParameterTypes().length != this.args.size()) continue;
                    method = methods[i];
                    break;
                }
                if (method == null) {
                    throw new Exception("Cannot find the method " + this.methodName + "for the object " + bean);
                }
            }
            cacheMethod_.put(cacheKey, method);
        }
        return method;
    }

    private Object getArgumentValue(Class type, String value) throws Exception {
        if (type.equals(String.class)) {
            if ((value = value.trim()).charAt(0) != '\"' && value.charAt(value.length() - 1) != '\"') {
                throw new Exception("Cannot instancitate parameter type " + type + " for value " + value);
            }
            return value.substring(1, value.length() - 1);
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return new Integer(value);
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return new Long(value);
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return new Double(value);
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return new Float(value);
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return new Boolean(value);
        }
        throw new Exception("Cannot instancitate parameter type " + type + " for value " + value);
    }

    public String testString(String s) {
        return "hello reply of " + s;
    }

    public int testInteger(int i) {
        return i;
    }

    public Integer testIntegerObject(Integer i) {
        return i;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.beanName);
        if (this.methodName != null) {
            b.append(".").append(this.methodName);
        }
        b.append("(");
        if (this.args != null) {
            for (int i = 0; i < this.args.size(); ++i) {
                b.append(this.args.get(i));
                if (i == this.args.size() - 1) continue;
                b.append(",");
            }
            if (this.error) {
                b.append(" [error = true]");
            }
        }
        b.append(")");
        return b.toString();
    }

    public static String inspect(Map map, String expression) {
        int length = expression.length();
        if (length < 3 || expression.charAt(0) != '$' || expression.charAt(1) != '{' || expression.charAt(length - 1) != '}') {
            return expression;
        }
        IntrospectionInfo info = new IntrospectionInfo(expression);
        if (info.error) {
            return expression;
        }
        if (info.methodName == null) {
            Object bean = map.get(info.beanName);
            if (bean == null) {
                return expression;
            }
            return bean.toString();
        }
        try {
            Object bean = map.get(info.beanName);
            Object ret = info.invoke(bean);
            return ret.toString();
        }
        catch (Exception ex) {
            return expression;
        }
    }
}

