/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.grammar.wiki.impl;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.grammar.wiki.WikiContext;
import org.exoplatform.services.grammar.wiki.impl.Token;
import org.exoplatform.services.grammar.wiki.impl.TokenHandlerManager;

public class ParsingContext {
    char[] buf_;
    int currentPosition_;
    Token currentToken_ = new Token(0, 0);
    private TokenHandlerManager tokenManager_;
    private StringBuffer out_;
    private WikiContext wikiContext_;

    public ParsingContext(InitParams params) {
        this.tokenManager_ = new TokenHandlerManager(params);
    }

    public StringBuffer getOutputBuffer() {
        return this.out_;
    }

    public void SetOutputBuffer(StringBuffer out) {
        this.out_ = out;
    }

    public WikiContext getWikiContext() {
        return this.wikiContext_;
    }

    public void setWikiContext(WikiContext context) {
        this.wikiContext_ = context;
    }

    public TokenHandlerManager getTokenHandlerManager() {
        return this.tokenManager_;
    }

    public void transform(String text) {
        this.buf_ = text.toCharArray();
        this.out_ = new StringBuffer();
        this.currentToken_.end = -1;
        Token token = this.nextToken(this.currentToken_);
        while (token != null) {
            token = this.tokenManager_.handleToken(null, token, this);
        }
    }

    public Token nextToken(Token previous) {
        this.currentPosition_ = previous.end + 1;
        if (this.currentPosition_ >= this.buf_.length) {
            return null;
        }
        this.currentToken_.start = this.currentPosition_;
        switch (this.buf_[this.currentPosition_]) {
            case '\\': {
                return this.readEscapeToken();
            }
            case '{': {
                return this.readCurlyBracePrefixToken();
            }
            case '-': {
                return this.readDashPrefixToken();
            }
            case '_': {
                return this.readUnderscorePrefixToken();
            }
            case '*': {
                return this.readStarPrefixToken();
            }
            case '~': {
                return this.readTildePrefixToken();
            }
            case ':': {
                return this.readColonPrefixToken();
            }
            case '[': {
                return this.readSquareBracePrefixToken();
            }
            case '$': {
                return this.readIntrospectionToken();
            }
            case '\n': 
            case '\r': {
                return this.readNewLinePrefixToken();
            }
        }
        return this.readDefaultToken();
    }

    private Token readEscapeToken() {
        ++this.currentPosition_;
        if (this.currentPosition_ == this.buf_.length) {
            --this.currentPosition_;
        }
        return this.createToken(this.currentPosition_, this.currentPosition_, "default", "single");
    }

    private Token readDefaultToken() {
        while (this.currentPosition_ < this.buf_.length) {
            switch (this.buf_[this.currentPosition_]) {
                case '\n': 
                case '\r': 
                case '$': 
                case '*': 
                case '-': 
                case ':': 
                case '[': 
                case '\\': 
                case '_': 
                case '{': 
                case '~': {
                    return this.createToken(--this.currentPosition_, "default", "single");
                }
            }
            ++this.currentPosition_;
        }
        return this.createToken(--this.currentPosition_, "default", "single");
    }

    private Token readCurlyBracePrefixToken() {
        while (this.currentPosition_ < this.buf_.length) {
            switch (this.buf_[this.currentPosition_]) {
                case '}': {
                    this.currentToken_ = this.createToken(this.currentPosition_, "{.+}", "block");
                    this.currentToken_.type = this.getSubstring(this.currentToken_.start, this.currentToken_.end);
                    return this.currentToken_;
                }
                case '\n': {
                    return this.createToken(--this.currentPosition_, "default", "single");
                }
            }
            ++this.currentPosition_;
        }
        return this.createToken(this.currentPosition_--, "default", "single");
    }

    private Token readSquareBracePrefixToken() {
        while (this.currentPosition_ < this.buf_.length) {
            switch (this.buf_[this.currentPosition_]) {
                case ']': {
                    return this.createToken(this.currentPosition_, "[.+]", "single");
                }
                case '\n': 
                case '\r': {
                    return this.createToken(--this.currentPosition_, "default", "single");
                }
            }
            ++this.currentPosition_;
        }
        return this.createToken(--this.currentPosition_, "default", "single");
    }

    private Token readColonPrefixToken() {
        while (this.currentPosition_ < this.buf_.length) {
            switch (this.buf_[this.currentPosition_]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return this.createToken(--this.currentPosition_, "smiley", "single");
                }
            }
            ++this.currentPosition_;
        }
        return this.createToken(--this.currentPosition_, "default", "single");
    }

    private Token readDashPrefixToken() {
        if (this.currentPosition_ + 1 >= this.buf_.length) {
            return this.createToken(this.currentPosition_, "default", "single");
        }
        if (this.buf_[this.currentPosition_] == '-' && this.buf_[this.currentPosition_ + 1] == '-') {
            int i;
            for (i = this.currentPosition_; i < this.buf_.length && this.buf_[i] == '-'; ++i) {
            }
            if (--i > this.currentPosition_ + 2) {
                this.currentPosition_ = i;
                return this.createToken(this.currentPosition_, "---", "single");
            }
            this.currentPosition_ = i;
            return this.createToken(this.currentPosition_, "--", "inline");
        }
        return this.createToken(this.currentPosition_, "default", "single");
    }

    private Token readUnderscorePrefixToken() {
        if (this.currentPosition_ + 1 >= this.buf_.length) {
            return this.createToken(this.currentPosition_, "default", "single");
        }
        if (this.buf_[this.currentPosition_] == '_' && this.buf_[this.currentPosition_ + 1] == '_') {
            return this.createToken(++this.currentPosition_, "__", "inline");
        }
        return this.createToken(this.currentPosition_, "default", "single");
    }

    private Token readStarPrefixToken() {
        if (this.currentPosition_ + 1 >= this.buf_.length) {
            return this.createToken(this.currentPosition_, "default", "single");
        }
        if (this.buf_[this.currentPosition_] == '*' && this.buf_[this.currentPosition_ + 1] == '*') {
            return this.createToken(++this.currentPosition_, "**", "inline");
        }
        if (this.buf_[this.currentPosition_] == '*') {
            return this.createToken(this.currentPosition_, "**", "inline");
        }
        return this.createToken(this.currentPosition_, "default", "single");
    }

    private Token readTildePrefixToken() {
        if (this.currentPosition_ + 1 >= this.buf_.length) {
            return this.createToken(this.currentPosition_, "default", "single");
        }
        if (this.buf_[this.currentPosition_] == '~' && this.buf_[this.currentPosition_ + 1] == '~') {
            return this.createToken(++this.currentPosition_, "~~", "inline");
        }
        return this.createToken(this.currentPosition_, "default", "single");
    }

    private Token readNewLinePrefixToken() {
        int i;
        int newLineCounter = 0;
        for (i = this.currentPosition_; i < this.buf_.length && (this.buf_[i] == '\n' || this.buf_[i] == '\r'); ++i) {
            if (this.buf_[i] != '\n') continue;
            ++newLineCounter;
        }
        if (newLineCounter > 1) {
            if (i == this.buf_.length) {
                --i;
            }
            if (this.buf_[i] != '\n' && this.buf_[i] != '\r') {
                --i;
            }
            this.currentPosition_ = i - 1;
            return this.createToken(this.currentPosition_, "\n+", "single");
        }
        while (i < this.buf_.length && (this.buf_[i] == ' ' || this.buf_[i] == '\t')) {
            ++i;
        }
        if (i + 2 < this.buf_.length) {
            if (this.buf_[i] == '*') {
                if (this.buf_[i] == '*' && this.buf_[i + 1] == '*' && this.buf_[i + 2] == '*') {
                    this.currentPosition_ = i + 2;
                    return this.createToken(this.currentPosition_, "\n ***", "block");
                }
                if (this.buf_[i] == '*' && this.buf_[i + 1] == '*') {
                    this.currentPosition_ = i + 1;
                    return this.createToken(this.currentPosition_, "\n **", "block");
                }
                this.currentPosition_ = i;
                return this.createToken(this.currentPosition_, "\n *", "block");
            }
            if (this.buf_[i] == '1') {
                if (this.buf_[i] == '1' && this.buf_[i + 1] == '.' && this.buf_[i + 2] == '1') {
                    this.currentPosition_ = i + 2;
                    return this.createToken(this.currentPosition_, "\n 1.1", "block");
                }
                if (this.buf_[i] == '1' && this.buf_[i + 1] == '.') {
                    this.currentPosition_ = i + 1;
                    return this.createToken(this.currentPosition_, "\n 1.", "block");
                }
                if (this.buf_[i] == '1' && this.buf_[i + 1] == ' ') {
                    this.currentPosition_ = i + 1;
                    return this.createToken(this.currentPosition_, "\n 1 ", "block");
                }
            }
            if (this.buf_[i] == 'a' && this.buf_[i + 1] == '.') {
                this.currentPosition_ = i + 1;
                return this.createToken(this.currentPosition_, "\n a.", "block");
            }
            if (this.buf_[i] == 'i' && this.buf_[i + 1] == '.') {
                this.currentPosition_ = i + 1;
                return this.createToken(this.currentPosition_, "\n i.", "block");
            }
        }
        if (i == this.buf_.length) {
            --i;
        }
        if (this.buf_[i] != '\n' && this.buf_[i] != '\r') {
            --i;
        }
        this.currentPosition_ = i;
        return this.createToken(this.currentPosition_, "\n", "single");
    }

    private Token readIntrospectionToken() {
        ++this.currentPosition_;
        if (this.currentPosition_ >= this.buf_.length || this.buf_[this.currentPosition_] != '{') {
            return this.createToken(--this.currentPosition_, "default", "single");
        }
        --this.currentPosition_;
        while (this.currentPosition_ < this.buf_.length) {
            switch (this.buf_[this.currentPosition_]) {
                case '}': {
                    return this.createToken(this.currentPosition_, "introspection", "single");
                }
                case '\n': 
                case '\r': {
                    return this.createToken(--this.currentPosition_, "default", "single");
                }
            }
            ++this.currentPosition_;
        }
        return this.createToken(--this.currentPosition_, "default", "single");
    }

    final Token createToken(int nextEnd, String type, String group) {
        this.currentToken_.end = nextEnd;
        this.currentToken_.type = type;
        this.currentToken_.group = group;
        return this.currentToken_;
    }

    final Token createToken(int start, int nextEnd, String type, String group) {
        this.currentToken_.start = start;
        this.currentToken_.end = nextEnd;
        this.currentToken_.type = type;
        this.currentToken_.group = group;
        return this.currentToken_;
    }

    public final String getSubstring(int offset, int end) {
        return new String(this.buf_, offset, end - offset + 1);
    }

    public final char[] getSubBuffer(int offset, int end) {
        char[] sub = new char[end - offset + 1];
        System.arraycopy(this.buf_, offset, sub, 0, sub.length);
        return sub;
    }

    public final void out(String s) {
        this.out_.append(s);
    }

    public final void out(Token token) {
        this.out_.append(this.buf_, token.start, token.end - token.start + 1);
    }
}

