/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ldap.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.ldap.CreateObjectCommand;
import org.exoplatform.services.ldap.DeleteObjectCommand;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.ldap.impl.LDAPConnectionConfig;

public class LDAPServiceImpl
implements LDAPService,
ComponentRequestLifecycle {
    private ThreadLocal<LdapContext> tlocal_ = new ThreadLocal();
    private Map<String, String> env = null;
    private int serverType = 0;

    public LDAPServiceImpl(InitParams params) throws Exception {
        LDAPConnectionConfig config = (LDAPConnectionConfig)params.getObjectParam("ldap.config").getObject();
        String url = config.getProviderURL();
        this.serverType = this.toServerType(config.getServerName());
        boolean ssl = url.toLowerCase().startsWith("ldaps");
        if (this.serverType == 1 && ssl) {
            String keystore = System.getProperty("java.home");
            keystore = keystore + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
            System.setProperty("javax.net.ssl.trustStore", keystore);
        }
        this.env = new HashMap<String, String>();
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.env.put("java.naming.security.authentication", config.getAuthenticationType());
        this.env.put("java.naming.security.principal", config.getRootDN());
        this.env.put("java.naming.security.credentials", config.getPassword());
        this.env.put("com.sun.jndi.ldap.connect.timeout", "60000");
        this.env.put("com.sun.jndi.ldap.connect.pool", "true");
        this.env.put("java.naming.ldap.version", config.getVerion());
        this.env.put("java.naming.ldap.attributes.binary", "tokenGroups");
        this.env.put("java.naming.referral", config.getReferralMode());
        Pattern pattern = Pattern.compile("\\p{Space}*,\\p{Space}*", 2);
        Matcher matcher = pattern.matcher(url);
        url = ssl ? matcher.replaceAll("/ ldaps://") : matcher.replaceAll("/ ldap://");
        url = url + "/";
        this.env.put("java.naming.provider.url", url);
        if (this.serverType == 1 && ssl) {
            this.env.put("java.naming.security.protocol", "ssl");
        }
    }

    public LdapContext getLdapContext() throws Exception {
        LdapContext context = this.tlocal_.get();
        if (context == null) {
            context = new InitialLdapContext(new Hashtable<String, String>(this.env), null);
            this.tlocal_.set(context);
        } else {
            context.setRequestControls(null);
        }
        return context;
    }

    public InitialContext getInitialContext() throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>(this.env);
        props.put("java.naming.factory.object", "com.sun.jndi.ldap.obj.LdapGroupFactory");
        props.put("java.naming.factory.state", "com.sun.jndi.ldap.obj.LdapGroupFactory");
        return new InitialLdapContext(props, null);
    }

    public boolean authenticate(String userDN, String password) throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>(this.env);
        props.put("java.naming.security.authentication", "simple");
        props.put("java.naming.security.principal", userDN);
        props.put("java.naming.security.credentials", password);
        props.put("com.sun.jndi.ldap.connect.pool", "false");
        new InitialLdapContext(props, null);
        return true;
    }

    public void addDeleteObject(ComponentPlugin plugin) throws Exception {
        DeleteObjectCommand command = (DeleteObjectCommand)plugin;
        LdapContext ctx = this.getLdapContext();
        command.deleteObjects(ctx);
    }

    public void addCreateObject(ComponentPlugin plugin) throws Exception {
        CreateObjectCommand command = (CreateObjectCommand)plugin;
        LdapContext ctx = this.getLdapContext();
        command.addObjects(ctx);
    }

    public void startRequest(ExoContainer container) {
    }

    public void endRequest(ExoContainer container) {
        LdapContext context = this.tlocal_.get();
        if (context != null) {
            try {
                context.close();
                this.tlocal_.set(null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private int toServerType(String name) {
        if ((name = name.trim()) == null || name.length() < 1) {
            return 0;
        }
        if (name.equalsIgnoreCase("ACTIVE.DIRECTORY")) {
            return 1;
        }
        return 0;
    }

    public int getServerType() {
        return this.serverType;
    }
}

