/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.impl;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.SecurityService;
import org.exoplatform.services.security.SubjectEventListener;
import org.exoplatform.services.security.impl.RolePrincipalImpl;
import org.exoplatform.services.security.impl.UserPrincipalImpl;
import org.exoplatform.services.security.jaas.JAASGroup;
import org.exoplatform.services.security.sso.SSOAuthenticationConfig;
import org.exoplatform.services.security.sso.impl.BaseSSOAuthentication;

public class SecurityServiceImpl
implements SecurityService {
    private Map subjects;
    private Log log_;
    private OrganizationService orgService_;
    private String authentication_;
    private BaseSSOAuthentication SSOAuthentication_;

    public SecurityServiceImpl(LogService logService, OrganizationService organizationService, InitParams params) {
        this.log_ = logService.getLog("org.exoplatform.services.security");
        this.orgService_ = organizationService;
        this.subjects = new HashMap();
        ValueParam param = params.getValueParam("security.authentication");
        this.authentication_ = null;
        this.SSOAuthentication_ = null;
        if (param != null) {
            this.authentication_ = param.getValue();
        }
        if (this.authentication_ == null || this.authentication_.equals("")) {
            this.authentication_ = "standalone";
        }
    }

    public boolean authenticate(String login, String password) throws Exception {
        if (password == null || "".equals(password)) {
            this.log_.debug((Object)"password must not be null or empty");
            throw new Exception("password must not be null or empty");
        }
        boolean result = this.orgService_.getUserHandler().authenticate(login, password);
        return result;
    }

    public void setUpAndCacheSubject(String userName, Subject value) throws Exception {
        Set<Principal> principals = value.getPrincipals();
        principals.add(new UserPrincipalImpl(userName));
        Collection groups = null;
        try {
            groups = this.orgService_.getGroupHandler().findGroupsOfUser(userName);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        JAASGroup roleGroup = new JAASGroup("Roles");
        for (org.exoplatform.services.organization.Group group : groups) {
            String groupId = group.getId();
            String[] splittedGroupName = StringUtils.split((String)groupId, (String)"/");
            roleGroup.addMember(new RolePrincipalImpl(splittedGroupName[0]));
        }
        value.getPrincipals().add((Principal)((Object)roleGroup));
        this.subjects.put(userName, value);
    }

    public void setUpAndCacheSubjectTomcat55(String userName, Subject value) throws Exception {
        Set<Principal> principals = value.getPrincipals();
        principals.add(new UserPrincipalImpl(userName));
        Collection groups = null;
        try {
            groups = this.orgService_.getGroupHandler().findGroupsOfUser(userName);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        for (org.exoplatform.services.organization.Group group : groups) {
            String groupId = group.getId();
            String[] splittedGroupName = StringUtils.split((String)groupId, (String)"/");
            value.getPrincipals().add(new RolePrincipalImpl(splittedGroupName[0]));
        }
        this.subjects.put(userName, value);
    }

    public boolean isUserInRole(String userName, String role) {
        Subject subject = (Subject)this.subjects.get(userName);
        if (subject == null) {
            return false;
        }
        Set<Group> roleGroups = subject.getPrincipals(Group.class);
        for (Group roleGroup : roleGroups) {
            Enumeration e = roleGroup.members();
            while (e.hasMoreElements()) {
                Principal rolePrincipal = (Principal)e.nextElement();
                if (!rolePrincipal.getName().equals(role)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasMembershipInGroup(String userId, String membershipName, String groupName) {
        Iterator groups;
        try {
            groups = this.orgService_.getGroupHandler().findGroupsOfUser(userId).iterator();
        }
        catch (Exception e) {
            return false;
        }
        if ("*".equals(membershipName)) {
            while (groups.hasNext()) {
                org.exoplatform.services.organization.Group group = (org.exoplatform.services.organization.Group)groups.next();
                if (!groupName.equals(group.getId())) continue;
                return true;
            }
        } else {
            while (groups.hasNext()) {
                org.exoplatform.services.organization.Group group = (org.exoplatform.services.organization.Group)groups.next();
                try {
                    for (Membership membership : this.orgService_.getMembershipHandler().findMembershipsByUserAndGroup(userId, group.getId())) {
                        if (!membership.getMembershipType().equals(membershipName)) continue;
                        return true;
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return false;
    }

    public boolean hasMembershipInGroup(String user, String roleExpression) {
        if ("*".equals(roleExpression)) {
            return true;
        }
        String membershipName = roleExpression.substring(0, roleExpression.indexOf(":"));
        String groupName = roleExpression.substring(roleExpression.indexOf(":") + 1);
        return this.hasMembershipInGroup(user, membershipName, groupName);
    }

    public Subject getSubject(String userName) {
        this.log_.debug((Object)("get subject for user " + userName));
        return (Subject)this.subjects.get(userName);
    }

    public void removeSubject(String userName) {
        this.log_.debug((Object)("remove subject for user " + userName));
        this.subjects.remove(userName);
    }

    public void addSubjectEventListener(SubjectEventListener subjectEventListener) {
    }

    public String getSSOAuthentication() {
        if (this.SSOAuthentication_ != null) {
            return this.SSOAuthentication_.getSSOAuthenticationConfig().getAuthenticationName();
        }
        return null;
    }

    public SSOAuthenticationConfig getSSOAuthenticationConfig() {
        if (this.SSOAuthentication_ != null) {
            return this.SSOAuthentication_.getSSOAuthenticationConfig();
        }
        return null;
    }

    public boolean isSSOAuthentication() {
        return "sso".equals(this.authentication_);
    }

    public boolean isStandaloneAuthentication() {
        return "standalone".equals(this.authentication_);
    }

    public String getProxyTicket(String userName, String urlOfTargetService) throws Exception {
        if (!this.isSSOAuthentication()) {
            throw new Exception("Portal is configured for standalone authentication. No proxy authentication feature available !");
        }
        if (this.SSOAuthentication_ == null) {
            throw new Exception("No SSO authentication configured !");
        }
        Iterator<Object> iter = this.getSubject(userName).getPrivateCredentials().iterator();
        if (!iter.hasNext()) {
            return null;
        }
        return this.SSOAuthentication_.getProxyTicket((String)iter.next(), urlOfTargetService);
    }

    public void setSSOAuthenticationPlugin(ComponentPlugin plugin) {
        this.SSOAuthentication_ = (BaseSSOAuthentication)plugin;
    }

    public Log getLog() {
        return this.log_;
    }

    public Map getSubjects() {
        return this.subjects;
    }

    public OrganizationService getOrgService() {
        return this.orgService_;
    }
}

