/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.impl;

import java.security.Principal;
import java.util.Collection;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.exception.ExoServiceException;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.SecurityService;
import org.exoplatform.services.security.impl.RolePrincipalImpl;
import org.exoplatform.services.security.impl.SecurityServiceImpl;
import org.exoplatform.services.security.impl.UserPrincipalImpl;

public class Tomcat55SecurityServiceImpl
extends SecurityServiceImpl
implements SecurityService {
    public Tomcat55SecurityServiceImpl(LogService logService, OrganizationService organizationService, InitParams params) {
        super(logService, organizationService, params);
    }

    public void setUpAndCacheSubject(String userName, Subject value) throws ExoServiceException {
        Set<Principal> principals = value.getPrincipals();
        principals.add(new UserPrincipalImpl(userName));
        Collection groups = null;
        try {
            groups = this.getOrgService().getGroupHandler().findGroupsOfUser(userName);
        }
        catch (Exception e) {
            throw new ExoServiceException((Throwable)e);
        }
        for (Group group : groups) {
            String groupId = group.getId();
            String[] splittedGroupName = StringUtils.split((String)groupId, (String)"/");
            value.getPrincipals().add(new RolePrincipalImpl(splittedGroupName[0]));
        }
        this.getSubjects().put(userName, value);
    }
}

