/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.ServletContext;
import org.exoplatform.faces.context.PortletExternalContext;

public class FacesUtil {
    public static PortletPreferences getPortletPreferences() {
        PortletRequest request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        return request.getPreferences();
    }

    public static String getInitParameter(String name) {
        PortletExternalContext context = (PortletExternalContext)FacesContext.getCurrentInstance().getExternalContext();
        return context.getConfig().getInitParameter(name);
    }

    public static String getApplicationRealPath(String s) {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext econtext = context.getExternalContext();
        ServletContext scontext = (ServletContext)econtext.getContext();
        return scontext.getRealPath(s);
    }

    public static ServletContext getServletContext() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext econtext = context.getExternalContext();
        return (ServletContext)econtext.getContext();
    }

    public static boolean isValueReference(String elexpr) {
        return elexpr != null && elexpr.startsWith("#{") && elexpr.endsWith("}");
    }

    public static void createValueBinding(FacesContext context, UIComponent uiComp, String key, String elexpr) {
        if (FacesUtil.isValueReference(elexpr)) {
            Application app = context.getApplication();
            if (uiComp.getValueBinding(key) == null) {
                uiComp.setValueBinding(key, app.createValueBinding(elexpr));
            }
        }
    }

    public static boolean updateBoundValueBinding(FacesContext context, UIComponent uiComp, String key, Object value) {
        boolean b = false;
        ValueBinding vb = uiComp.getValueBinding(key);
        if (vb != null) {
            vb.setValue(context, value);
            b = true;
        }
        return b;
    }

    public static Object resolveBoundValueBinding(FacesContext context, UIComponent uiComp, String key) {
        Object value = null;
        ValueBinding vb = uiComp.getValueBinding(key);
        if (vb != null) {
            value = vb.getValue(context);
        }
        return value;
    }
}

