/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces;

import java.lang.reflect.Constructor;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faces.context.PortletExternalContext;
import org.exoplatform.faces.core.component.UIExoComponent;

public class UIComponentFactory {
    private ResourceBundle res_;

    public UIComponentFactory(ResourceBundle res) {
        this.res_ = res;
    }

    public UIComponentFactory() {
        FacesContext context = FacesContext.getCurrentInstance();
        PortletExternalContext econtext = (PortletExternalContext)context.getExternalContext();
        this.res_ = econtext.getApplicationResourceBundle();
    }

    public final Object createUIComponent(String className) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = cl.loadClass(className);
        return this.createUIComponent(clazz);
    }

    public final Object createUIComponent(Class clazz) throws Exception {
        PortalContainer manager = PortalContainer.getInstance();
        return this.createUIComponent(clazz, manager);
    }

    private Object createUIComponent(Class clazz, PortalContainer manager) throws Exception {
        Constructor constructor = this.findBiggestConstructor(clazz);
        Class<?>[] parameters = constructor.getParameterTypes();
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < args.length; ++i) {
            if (UIComponent.class.isAssignableFrom(parameters[i])) {
                args[i] = this.createUIComponent(parameters[i], manager);
                continue;
            }
            if (ResourceBundle.class.isAssignableFrom(parameters[i])) {
                args[i] = this.res_;
                continue;
            }
            args[i] = manager.getComponentInstanceOfType(parameters[i]);
            if (args[i] != null) continue;
            throw new Exception("Cannot find the service " + parameters[i].getName());
        }
        Object result = constructor.newInstance(args);
        return result;
    }

    private Constructor findBiggestConstructor(Class clazz) {
        Constructor<?> bc = null;
        Constructor<?>[] constructors = clazz.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (bc == null) {
                bc = constructors[i];
                continue;
            }
            if (bc.getParameterTypes().length >= constructors[i].getParameterTypes().length) continue;
            bc = constructors[i];
        }
        return bc;
    }

    public static UIExoComponent createComponent(Class cl) throws Exception {
        String className = cl.getName();
        int idx = className.lastIndexOf(46);
        className = className.substring(idx + 1, className.length());
        PortalContainer pcontainer = PortalContainer.getInstance();
        UIExoComponent uiComponent = (UIExoComponent)pcontainer.createComponent(cl);
        uiComponent.setId(className);
        return uiComponent;
    }
}

