/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.component;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.validator.Validator;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faces.ValidatorManager;
import org.exoplatform.faces.core.component.UIExoComponent;

public class ComponentUtil {
    public static List findDescendantsOfType(UIComponent comp, Class type) {
        ArrayList list = new ArrayList();
        ComponentUtil.findDescendantsOfType(comp, type, list);
        return list;
    }

    private static void findDescendantsOfType(UIComponent uiComp, Class type, List list) {
        if (uiComp.getChildCount() == 0) {
            return;
        }
        List children = uiComp.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIComponent child = (UIComponent)children.get(i);
            if (type.isInstance(child)) {
                list.add(child);
            }
            ComponentUtil.findDescendantsOfType(child, type, list);
        }
    }

    public static UIComponent findDescendantOfType(UIComponent uiComp, Class type) {
        List children = uiComp.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIComponent child = (UIComponent)children.get(i);
            if (type.isInstance(child)) {
                return child;
            }
            UIComponent found = ComponentUtil.findDescendantOfType(child, type);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static UIExoComponent findComponentById(UIExoComponent comp, String id) {
        if (id.equals(comp.getId())) {
            return comp;
        }
        List children = comp.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIExoComponent uiChild = (UIExoComponent)children.get(i);
            UIExoComponent result = ComponentUtil.findComponentById(uiChild, id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static UIExoComponent findRenderedComponentById(UIExoComponent uiComp, String id) {
        if (id.equals(uiComp.getId())) {
            return uiComp;
        }
        List children = uiComp.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIExoComponent result;
            UIExoComponent uiChild = (UIExoComponent)children.get(i);
            if (!uiChild.isRendered() || (result = ComponentUtil.findRenderedComponentById(uiChild, id)) == null) continue;
            return result;
        }
        return null;
    }

    public static Object getChildComponentOfType(UIComponent comp, Class classType) {
        List children = comp.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Object o = children.get(i);
            if (!classType.isInstance(o)) continue;
            return o;
        }
        return null;
    }

    public static UIComponent getAncestorOfType(UIComponent comp, Class classType) {
        for (UIComponent parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (!classType.isInstance(parent)) continue;
            return parent;
        }
        return null;
    }

    public static void setRenderedComponent(UIExoComponent comp, String id) {
        List children = comp.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIComponent child = (UIComponent)children.get(i);
            if (child.getId().equals(id)) {
                child.setRendered(true);
                continue;
            }
            child.setRendered(false);
        }
    }

    public static void setRenderedComponent(UIExoComponent comp, Class type) {
        List children = comp.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIComponent child = (UIComponent)children.get(i);
            if (type.isInstance(child)) {
                child.setRendered(true);
                continue;
            }
            child.setRendered(false);
        }
    }

    public static void setRenderedSibling(UIExoComponent comp, Class type) {
        List children = comp.getParent().getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIComponent child = (UIComponent)children.get(i);
            if (type.isInstance(child)) {
                child.setRendered(true);
                continue;
            }
            child.setRendered(false);
        }
    }

    public static UIComponent getSibling(UIComponent comp, Class type) {
        List children = comp.getParent().getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIComponent child = (UIComponent)children.get(i);
            if (!type.isInstance(child)) continue;
            return child;
        }
        return null;
    }

    public static void addValidator(List list, Class clazz) {
        PortalContainer pcontainer = PortalContainer.getInstance();
        ValidatorManager manager = (ValidatorManager)pcontainer.getComponentInstanceOfType(ValidatorManager.class);
        Validator result = manager.getValidator(clazz);
        list.add(result);
    }

    public static Validator getValidator(Class clazz) {
        PortalContainer pcontainer = PortalContainer.getInstance();
        ValidatorManager manager = (ValidatorManager)pcontainer.getComponentInstanceOfType(ValidatorManager.class);
        return manager.getValidator(clazz);
    }
}

