/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.component;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.exoplatform.faces.context.PortletFacesContext;
import org.exoplatform.faces.core.component.UIExoComponentBase;

public class UIFatalError
extends UIExoComponentBase {
    private Throwable exception_;

    public UIFatalError(Throwable ex) {
        this.setId("UIFatalError");
        this.exception_ = ex;
    }

    public void decode(FacesContext context) {
        PortletFacesContext pcontext = (PortletFacesContext)context;
        pcontext.destroy();
    }

    public final void encodeBegin(FacesContext context) throws IOException {
        String baseURL = context.getExternalContext().encodeActionURL(null);
        ResponseWriter w = context.getResponseWriter();
        w.write("<div>");
        w.write("The portlet has a fatal error. Click here to restart the portlet");
        this.renderButton(w, baseURL);
        w.write("</div>");
        w.write("<div style='border: 1px dashed black'>");
        String message = this.exception_.getMessage();
        if (message != null) {
            w.write(this.exception_.getMessage());
        }
        w.write(this.getStackTrace(this.exception_));
        w.write("</div>");
    }

    private void renderButton(ResponseWriter w, String baseURL) throws IOException {
        w.write("<a href='");
        w.write(baseURL);
        w.write(38);
        w.write("op");
        w.write("=restart");
        w.write("'>");
        w.write("Click");
        w.write("</a>");
    }

    private String getStackTrace(Throwable t) {
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        PrintStream pstream = new PrintStream(ostream);
        t.printStackTrace(pstream);
        return new String(ostream.toByteArray());
    }

    public final void encodeChildren(FacesContext context) throws IOException {
    }

    public final void encodeEnd(FacesContext context) throws IOException {
    }
}

