/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.component;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faces.core.component.UIUploadInput;
import org.exoplatform.services.document.image.ImageProcessingService;
import org.exoplatform.services.log.ExoLogger;

public class UIImageUploadInput
extends UIUploadInput {
    private String contentType;
    private List options;
    private static String GIF_FORMAT = "gif";
    private static String TIFF_FORMAT = "tiff";
    private static String JPG_FORMAT = "jpg";
    private static Log log_ = ExoLogger.getLogger((String)"jsf.UIImageUploadInput");

    public UIImageUploadInput(String name) {
        super(name);
        this.setRendererType("ImageUploadInputRenderer");
    }

    public UIImageUploadInput(String name, List optionList) {
        super(name);
        this.options = optionList;
        this.setRendererType("ImageUploadInputRenderer");
    }

    public void decodeFromMultipartFields(FacesContext context, UIComponent component, List items) {
        PortalContainer container = PortalContainer.getInstance();
        ImageProcessingService imageProcessingService = (ImageProcessingService)container.getComponentInstanceOfType(ImageProcessingService.class);
        for (FileItem item : items) {
            if (!item.isFormField()) {
                String name = item.getFieldName();
                this.setContentType(item.getContentType());
                if (!name.equals(this.getName())) continue;
                String[] fileNameItems = item.getName().split("\\\\|/");
                String fileName = fileNameItems[fileNameItems.length - 1];
                String formatName = fileName.substring(fileName.lastIndexOf(".") + 1);
                if (fileName == null || fileName.equals("")) continue;
                try {
                    this.setFileName(fileName);
                    if (formatName.equalsIgnoreCase(GIF_FORMAT) || formatName.equalsIgnoreCase(TIFF_FORMAT)) {
                        formatName = JPG_FORMAT;
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(item.get());
                    BufferedImage img = ImageIO.read(bais);
                    bais.close();
                    BufferedImage imageBuf = null;
                    String transformOption = (String)this.options.get(0);
                    if (transformOption != null && !"".equals(transformOption) && transformOption.equalsIgnoreCase("crop")) {
                        int chosenWidth = Integer.parseInt((String)this.options.get(1));
                        int chosenHeight = Integer.parseInt((String)this.options.get(2));
                        imageBuf = imageProcessingService.createCroppedImage(img, chosenWidth, chosenHeight);
                    } else if (transformOption != null && !"".equals(transformOption) && transformOption.equalsIgnoreCase("bound")) {
                        int chosenWidth = Integer.parseInt((String)this.options.get(1));
                        int chosenHeight = Integer.parseInt((String)this.options.get(2));
                        String bgColor = "";
                        if (this.options.size() == 4) {
                            bgColor = (String)this.options.get(3);
                        }
                        imageBuf = imageProcessingService.createBoundImage(img, chosenWidth, chosenHeight, bgColor);
                    } else if (transformOption != null && !"".equals(transformOption) && transformOption.equalsIgnoreCase("scale")) {
                        imageBuf = imageProcessingService.createScaledImage(img, Double.parseDouble((String)this.options.get(1)));
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    try {
                        ImageIO.write(imageBuf, formatName, out);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.setContent(out.toByteArray());
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            String checkBoxFieldName = "remove-" + this.getName();
            if (!item.getFieldName().equals(checkBoxFieldName)) continue;
            byte[] buf = item.get();
            this.setContent(buf);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

