/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.component;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.exoplatform.faces.core.Util;
import org.exoplatform.faces.core.component.ComponentUtil;
import org.exoplatform.faces.core.component.UICheckBox;
import org.exoplatform.faces.core.component.UIDateInput;
import org.exoplatform.faces.core.component.UIDateTimeInput;
import org.exoplatform.faces.core.component.UIExoCommand;
import org.exoplatform.faces.core.component.UIHiddenInput;
import org.exoplatform.faces.core.component.UIInput;
import org.exoplatform.faces.core.component.UIIntegerInput;
import org.exoplatform.faces.core.component.UIRadioBox;
import org.exoplatform.faces.core.component.UISelectBox;
import org.exoplatform.faces.core.component.UIStringInput;
import org.exoplatform.faces.core.component.UIUploadInput;
import org.exoplatform.portal.Information;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UISimpleForm
extends UIExoCommand {
    public static final String SIMPLE_FORM_RENDERER = "SimpleFormRenderer";
    public static final short ALL_MODE = 0;
    public static final short VIEW_MODE = 1;
    public static final short EDIT_MODE = 2;
    private List hiddenInputs_;
    private Map inputs_;
    protected boolean error_;
    private String formName_;
    private String method_;
    private String formId_;
    private String userAction_;
    protected List validators_;
    private String script_;
    private short mode_;

    public UISimpleForm(String name, String method, String formId) {
        this.formName_ = name;
        this.method_ = method;
        this.formId_ = formId;
        if (this.formId_ == null) {
            this.formId_ = name;
        }
        this.setRendererType(SIMPLE_FORM_RENDERER);
        this.setId(name);
        this.mode_ = (short)2;
        this.inputs_ = new HashMap();
    }

    public boolean hasError() {
        return this.error_;
    }

    public void setError(boolean b) {
        this.error_ = b;
    }

    public String getFormName() {
        return this.formName_;
    }

    public void setFormName(String formName) {
        this.formName_ = formName;
    }

    public String getMethod() {
        return this.method_;
    }

    public String getFormId() {
        return this.formId_;
    }

    public String getUserAction() {
        return this.userAction_;
    }

    public void setUserAction(String userAction) {
        this.userAction_ = userAction;
    }

    public List getHiddenInputs() {
        return this.hiddenInputs_;
    }

    public String getScript() {
        if (this.script_ == null) {
            this.script_ = this.getNormalScript();
        }
        return this.script_;
    }

    public String getSaveAction() {
        return "save";
    }

    public String getCancelAction() {
        return CANCEL_ACTION;
    }

    public UISimpleForm add(UIHiddenInput input) {
        this.getChildren().add(input);
        if (this.hiddenInputs_ == null) {
            this.hiddenInputs_ = new ArrayList(3);
        }
        this.hiddenInputs_.add(input);
        return this;
    }

    public void add(UIInput input) {
        if (this.isMultiValue(input.getName())) {
            this.remove(input.getName());
        }
        this.getChildren().add(input);
        if (this.inputs_ == null) {
            this.inputs_ = new HashMap(10);
        }
        this.inputs_.put(input.getName(), input);
    }

    public void addValue(UIInput input) {
        String name = input.getName();
        if (this.getUIInput(name) == null) {
            this.add(input);
            return;
        }
        int index = this.getNumberOfValues(name);
        String realName = name + "[" + index + "]";
        input.setName(realName);
        this.getChildren().add(input);
        if (this.inputs_ == null) {
            this.inputs_ = new HashMap(10);
        }
        this.inputs_.put(input.getName(), input);
    }

    public void removeValue(String valueName) {
        String index;
        int firstIndex = valueName.indexOf("[");
        String name = valueName.substring(0, firstIndex);
        int valueIndex = Integer.parseInt(valueName.substring(firstIndex + 1, firstIndex + 2));
        UIInput input = null;
        int i = 1;
        while ((input = (UIInput)this.inputs_.get(index = name + "[" + i + "]")) != null) {
            if (i == valueIndex) {
                this.getChildren().remove(input);
                this.inputs_.remove(index);
            } else if (i > valueIndex) {
                this.getChildren().remove(input);
                this.inputs_.remove(index);
                String newName = name + "[" + (i - 1) + "]";
                input.setName(newName);
                this.getChildren().add(input);
                this.inputs_.put(newName, input);
            }
            ++i;
        }
    }

    public void remove(String name) {
        if (this.isMultiValue(name)) {
            String index;
            this.getChildren().removeAll(this.getMultipleValuesUIInput(name));
            this.inputs_.remove(name);
            int i = 1;
            while (this.getUIInput(index = name + "[" + i + "]") != null) {
                this.inputs_.remove(index);
                ++i;
            }
        } else {
            this.getChildren().remove(this.getUIInput(name));
            this.inputs_.remove(name);
        }
    }

    public UIInput getUIInput(String name) {
        return (UIInput)this.inputs_.get(name);
    }

    public void clearInputs() {
        this.inputs_ = new HashMap();
        this.hiddenInputs_ = new ArrayList();
    }

    public boolean isMultiValue(String name) {
        String firstIndex = name + "[1]";
        return this.inputs_.get(firstIndex) != null;
    }

    public int getNumberOfValues(String name) {
        if (!this.isMultiValue(name)) {
            return 1;
        }
        return this.getMultipleValuesUIInput(name).size();
    }

    public List<UIInput> getMultipleValuesUIInput(String name) {
        ArrayList<UIInput> values = new ArrayList<UIInput>();
        UIInput input = (UIInput)this.inputs_.get(name);
        if (input == null) {
            return values;
        }
        values.add(input);
        int i = 1;
        String index;
        while ((input = (UIInput)this.inputs_.get(index = name + "[" + i + "]")) != null) {
            values.add(input);
            ++i;
        }
        return values;
    }

    public UIStringInput getUIStringInput(String name) {
        return (UIStringInput)this.inputs_.get(name);
    }

    public UISelectBox getUISelectBox(String name) {
        return (UISelectBox)this.inputs_.get(name);
    }

    public UIRadioBox getUIRadioBox(String name) {
        return (UIRadioBox)this.inputs_.get(name);
    }

    public UICheckBox getUICheckBox(String name) {
        return (UICheckBox)this.inputs_.get(name);
    }

    public UIUploadInput getUIUploadInput(String name) {
        return (UIUploadInput)this.inputs_.get(name);
    }

    public UIDateInput getUIDateInput(String name) {
        return (UIDateInput)this.inputs_.get(name);
    }

    public UIDateTimeInput getUIDateTimeInput(String name) {
        return (UIDateTimeInput)this.inputs_.get(name);
    }

    public UIIntegerInput getUIIntegerInput(String name) {
        return (UIIntegerInput)this.inputs_.get(name);
    }

    public void setFieldValue(String name, String value) {
        UIInput input = (UIInput)this.inputs_.get(name);
        input.setValue(value);
    }

    public void setFieldValue(String name, Date date) {
        UIDateInput input = (UIDateInput)this.inputs_.get(name);
        input.addDate(date);
    }

    public Map getUIInputs() {
        return this.inputs_;
    }

    public void reset() {
        Map map = this.getUIInputs();
        ArrayList<UIInput> inputsToRemove = new ArrayList<UIInput>();
        for (UIInput input : map.values()) {
            if (input.getName().contains("[")) {
                inputsToRemove.add(input);
                continue;
            }
            input.reset();
        }
        for (UIInput input : inputsToRemove) {
            this.getChildren().remove(input);
            this.inputs_.remove(input.getName());
        }
    }

    public void addValidator(Validator validator) {
        if (this.validators_ == null) {
            this.validators_ = new ArrayList(3);
        }
        this.validators_.add(validator);
    }

    public void addValidator(Class clazz) {
        if (this.validators_ == null) {
            this.validators_ = new ArrayList(3);
        }
        ComponentUtil.addValidator(this.validators_, clazz);
    }

    public short getMode() {
        return this.mode_;
    }

    public void setMode(short mode) {
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Object child = children.get(i);
            if (!(child instanceof UIInput)) continue;
            UIInput input = (UIInput)child;
            if (1 == mode) {
                input.setReadonly(true);
                this.mode_ = 1;
                continue;
            }
            input.setReadonly(false);
            this.mode_ = (short)2;
        }
    }

    @Override
    public void decode(FacesContext context) {
        this.getRenderer(context).decode(context, (UIComponent)this);
    }

    @Override
    public void processDecodes(FacesContext context) {
        this.error_ = false;
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String uicomponent = (String)paramMap.get("uicomponent");
        if (!this.getId().equals(uicomponent)) {
            return;
        }
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIComponent child = (UIComponent)children.get(i);
            child.processDecodes(context);
        }
        this.decode(context);
    }

    public final void processValidators(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIComponent uiChild = (UIComponent)children.get(i);
            if (!uiChild.isRendered()) continue;
            uiChild.processValidators(context);
        }
        if (context.getRenderResponse()) {
            return;
        }
        this.error_ = false;
        if (this.validators_ != null) {
            Validator validator = null;
            try {
                for (int i = 0; i < this.validators_.size(); ++i) {
                    validator = (Validator)this.validators_.get(i);
                    validator.validate(context, (UIComponent)this, null);
                }
            }
            catch (ValidatorException ex) {
                this.error_ = true;
                FacesMessage message = ex.getFacesMessage();
                Information iprovider = Util.findInformationProvider((UIComponent)this);
                iprovider.addMessage(message);
                context.renderResponse();
            }
        }
    }

    private String getNormalScript() {
        String script = "<script type='text/javascript'>\n  //ie bug  you cannot have more than one button tag\n  function submit_" + this.formName_ + "(action) {\n" + "    document." + this.formName_ + ".elements['" + "op" + "'].value = action ;\n" + "    document." + this.formName_ + ".submit();\n" + "  }\n" + "</script>\n";
        return script;
    }

    public void setNoScript() {
        this.script_ = "";
    }

    public void setEnhancedScript(String taId, String width, String height) {
        String script;
        this.script_ = script = "<script type='text/javascript'>\n  _editor_url = '/htmlarea';\n  _editor_lang = 'en'; \n</script><script type='text/javascript' src='/htmlarea/htmlarea.js'></script>\n<script type='text/javascript'>\n  var editor = null;\n  function initEditor() {\n    editor = new HTMLArea('" + taId + "');\n" + "    var cfg = editor.config; // this is the default configuration\n" + "    editor.generate();\n" + "    editor._iframe.style.width = \"" + width + "\";" + "    editor._textArea.style.width = \"" + width + "\";" + "    editor._iframe.style.height = \"" + height + "\";" + "    editor._textArea.style.height = \"" + height + "\";" + "  }\n" + "  //ie bug  you cannot have more than one button tag\n" + "  function submit_" + this.formName_ + "(action) {\n" + "    document." + this.formName_ + ".elements['" + "op" + "'].value = action ;\n" + "    document." + this.formName_ + ".onsubmit();\n" + "    document." + this.formName_ + ".submit();\n" + "  }\n" + "  initEditor() ;\n" + "</script>\n";
    }
}

