/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.component.model;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.faces.context.ResponseWriter;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.faces.core.component.UIExoComponent;
import org.exoplatform.faces.core.component.model.Parameter;

public class Button {
    protected String label_;
    protected String parameters_;
    protected boolean activate_;
    private boolean visible_ = true;

    public Button(String name, String params) {
        this.label_ = name;
        this.parameters_ = params;
        this.activate_ = true;
    }

    public Button(String name, Parameter[] params) {
        this.label_ = name;
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            b.append("&amp;");
            b.append(params[i].getName()).append('=').append(params[i].getValue());
        }
        this.parameters_ = b.toString();
        this.activate_ = true;
    }

    public void setActivate(boolean b) {
        this.activate_ = b;
    }

    public void setVisible(boolean visible) {
        this.visible_ = visible;
    }

    public boolean isVisible() {
        return this.visible_;
    }

    public void render(ResponseWriter w, ResourceBundle res, UIExoComponent uiParent, String objectId) throws IOException {
        if (!this.visible_) {
            return;
        }
        if (this.activate_) {
            String baseURL = uiParent.getBaseURL();
            w.write("<a");
            w.write(" href='");
            w.write(baseURL);
            w.write(this.parameters_);
            if (objectId != null) {
                w.write("&amp;objectId=");
                w.write(objectId);
            }
            w.write("'>");
            w.write(ExpressionUtil.getExpressionValue((ResourceBundle)res, (String)this.label_));
            w.write("</a>");
        } else {
            w.write("<span>");
            w.write(ExpressionUtil.getExpressionValue((ResourceBundle)res, (String)this.label_));
            w.write("<span>");
        }
    }
}

