/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.event;

import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import org.exoplatform.commons.exception.ExoMessageException;
import org.exoplatform.commons.utils.ExceptionUtil;
import org.exoplatform.faces.application.ExoFacesMessage;
import org.exoplatform.faces.core.Util;
import org.exoplatform.faces.core.event.ExceptionHandler;
import org.exoplatform.faces.core.event.ExoActionEvent;
import org.exoplatform.portal.Information;

public class MessageExceptionHandler
extends ExceptionHandler {
    public boolean canHandleError(Throwable error) {
        return error instanceof ExoMessageException;
    }

    public void handle(ExoActionEvent action, Throwable error) {
        ExoMessageException ex = (ExoMessageException)error;
        UIComponent src = action.getComponent();
        Information iprovider = Util.findInformationProvider(src);
        if (iprovider != null) {
            ResourceBundle res = Util.getApplicationResourceBundle();
            String message = ex.getMessage(res);
            String stackTrace = null;
            if (ex.getSeverity() <= 2) {
                stackTrace = ExceptionUtil.getStackTrace((Throwable)new Exception(), (int)3);
            }
            iprovider.addMessage((FacesMessage)new ExoFacesMessage(FacesMessage.SEVERITY_ERROR, message, stackTrace, ex.getArguments()));
        }
    }
}

