/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.renderer.html;

import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.exoplatform.faces.core.component.UIDateInput;
import org.exoplatform.faces.core.component.UISimpleForm;
import org.exoplatform.faces.core.renderer.html.HtmlBasicRenderer;

public class DateInputRenderer
extends HtmlBasicRenderer {
    public void decode(FacesContext context, UIComponent component) {
        UIDateInput uiInput = (UIDateInput)component;
        Calendar cal = uiInput.getCalendar();
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String dayValue = (String)paramMap.get(uiInput.getName() + "_dd");
        String monthValue = (String)paramMap.get(uiInput.getName() + "_mm");
        String yearValue = (String)paramMap.get(uiInput.getName() + "_yyyy");
        try {
            cal.set(5, Integer.parseInt(dayValue));
            cal.set(2, Integer.parseInt(monthValue));
            cal.set(1, Integer.parseInt(yearValue));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter w = context.getResponseWriter();
        UIDateInput uiInput = (UIDateInput)component;
        StringBuffer b = new StringBuffer(200);
        ResourceBundle res = DateInputRenderer.getApplicationResourceBundle(context.getExternalContext());
        String formName = ((UISimpleForm)uiInput.getParent()).getFormName();
        String name = uiInput.getName();
        this.renderJavascript(b, uiInput.getName(), formName, res.getLocale().getLanguage());
        Calendar cal = uiInput.getCalendar();
        this.renderField(b, uiInput, name + "_dd", cal.get(5), 1, cal.getActualMaximum(5));
        this.renderField(b, uiInput, name + "_mm", cal.get(2), this.buildMonthArray(res));
        this.renderField(b, uiInput, name + "_yyyy", cal.get(1), uiInput.getMinYearRange(), uiInput.getMaxYearRange());
        this.renderImage(b, name);
        w.write(b.toString());
        if (uiInput.hasSelectors()) {
            Collection selectors = uiInput.getSelectors();
            for (String button : selectors) {
                w.write(button);
            }
        }
        if (uiInput.hasError()) {
            w.write("<span style='color: red'>*</span>");
        }
    }

    private String[] buildMonthArray(ResourceBundle res) {
        String[] months = new String[12];
        for (int i = 0; i < months.length; ++i) {
            months[i] = res.getString("UIDateInput.month-" + i);
        }
        return months;
    }

    private void renderJavascript(StringBuffer b, String name, String formName, String locale) {
        b.append("<script language=\"JavaScript\" src=\"/resources/community/script/calendar/calendar.js\">");
        b.append("</script>");
        b.append("<script language=\"JavaScript\" src=\"/resources/community/script/calendar/calendar-setup.js\">");
        b.append("</script>");
        b.append("<script language=\"JavaScript\" src=\"/resources/community/script/calendar/lang/calendar-").append(locale).append(".js\">");
        b.append("</script>");
        b.append("<script language='JavaScript'>");
        b.append("var ").append(name).append("_calendar = new Calendar(false, null,");
        b.append(name).append("_calendar_onSelect,");
        b.append(name).append("_calendar_onClose);");
        b.append(name).append("_calendar.weekNumbers = false;");
        b.append(name).append("_calendar.firstDayOfWeek = 0;");
        b.append(name).append("_calendar.setTtDateFormat(\"%A, %B %e, %Y\");");
        b.append(name).append("_calendar.setRange(2000, 2010);");
        b.append("function setSelectedValue(col, value) {");
        b.append("for (var i = 0; i < col.length; i++) {");
        b.append("if (col[i].value == value) {");
        b.append("col.selectedIndex = i;");
        b.append("break;");
        b.append("}}}");
        b.append("function ").append(name).append("_calendar_onClick(id) {");
        b.append(name).append("_calendar.create();");
        b.append(name).append("_calendar.setDate(new Date(");
        b.append("document.");
        b.append("getElementById('").append(name).append("_yyyy");
        b.append("')").append(".value, ");
        b.append("document.").append("getElementById('");
        b.append(name).append("_mm");
        b.append("')").append(".value, ");
        b.append("document.").append("getElementById('");
        b.append(name).append("_dd");
        b.append("')").append(".value));");
        b.append(name).append("_calendar.showAtElement(document.getElementById('");
        b.append(name);
        b.append("_calendarImage'), 'br');");
        b.append("}");
        b.append("function ").append(name).append("_calendar_onClose(cal) {cal.hide();}");
        b.append("function ").append(name).append("_calendar_onSelect(cal) {");
        b.append("if (cal.dateClicked) {");
        b.append("setSelectedValue(");
        b.append("document.").append("getElementById('").append(name).append("_mm");
        b.append("')").append(",");
        b.append("cal.date.getMonth());");
        b.append("setSelectedValue(");
        b.append("document.").append("getElementById('").append(name).append("_dd");
        b.append("')").append(",");
        b.append("cal.date.getDate());");
        b.append("setSelectedValue(");
        b.append("document.").append("getElementById('").append(name).append("_yyyy");
        b.append("')").append(",");
        b.append("cal.date.getFullYear());");
        b.append("cal.callCloseHandler();");
        b.append("}");
        b.append("}");
        b.append("</script>");
    }

    private void renderImage(StringBuffer b, String name) {
        b.append("<img id=\"");
        b.append(name);
        b.append("_calendarImage\" src=\"");
        b.append("/resources/community/images/calendar/calendar.gif\"");
        b.append(" onClick=\"").append(name).append("_calendar_onClick('").append(name).append("_calendar');\"/>");
    }

    private void renderField(StringBuffer b, UIDateInput uiInput, String name, int value, int minRange, int maxRange) {
        b.append("<select  style='width: auto;' name='").append(name).append("'").append(" id='").append(name).append("'");
        if (!uiInput.isEditable() || uiInput.isReadonly()) {
            b.append(" disabled='true'");
        }
        if (uiInput.getClazz() != null) {
            b.append(" class='").append(uiInput.getClazz()).append("'");
        }
        b.append(">\n");
        for (int i = minRange; i <= maxRange; ++i) {
            if (i == value) {
                b.append("<option selected=\"selected\" value=\"").append(i).append("\">").append(i).append("</option>\n");
                continue;
            }
            b.append("<option value=\"").append(i).append("\">").append(i).append("</option>\n");
        }
        b.append("</select>\n");
    }

    private void renderField(StringBuffer b, UIDateInput uiInput, String name, int value, String[] values) {
        b.append("<select style='width: auto;' name='").append(name).append("'").append(" id='").append(name).append("'");
        if (!uiInput.isEditable() || uiInput.isReadonly()) {
            b.append(" disabled='true'");
        }
        if (uiInput.getClazz() != null) {
            b.append(" class='").append(uiInput.getClazz()).append("'");
        }
        b.append(">\n");
        for (int i = 0; i < values.length; ++i) {
            if (i == value) {
                b.append("<option selected=\"selected\" value=\"").append(i).append("\">").append(values[i]).append("</option>\n");
                continue;
            }
            b.append("<option value=\"").append(i).append("\">").append(values[i]).append("</option>\n");
        }
        b.append("</select>\n");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }
}

