/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.renderer.html;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.exoplatform.faces.core.component.UIDateTimeInput;
import org.exoplatform.faces.core.component.UISimpleForm;
import org.exoplatform.faces.core.renderer.html.HtmlBasicRenderer;

public class DateTimeInputRenderer
extends HtmlBasicRenderer {
    public void decode(FacesContext context, UIComponent component) {
        UIDateTimeInput uiInput = (UIDateTimeInput)component;
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String strInput = (String)paramMap.get(uiInput.getName() + "_dd");
        if (strInput == null || "".equals(strInput)) {
            return;
        }
        int day = Integer.parseInt(strInput);
        strInput = (String)paramMap.get(uiInput.getName() + "_mm");
        if (strInput == null || "".equals(strInput)) {
            return;
        }
        int month = Integer.parseInt(strInput);
        strInput = (String)paramMap.get(uiInput.getName() + "_yyyy");
        if (strInput == null || "".equals(strInput)) {
            return;
        }
        int year = Integer.parseInt(strInput);
        strInput = (String)paramMap.get(uiInput.getName() + "_hh");
        if (strInput == null || "".equals(strInput)) {
            return;
        }
        int hour = Integer.parseInt(strInput);
        strInput = (String)paramMap.get(uiInput.getName() + "_min");
        if (strInput == null || "".equals(strInput)) {
            return;
        }
        int minute = Integer.parseInt(strInput);
        GregorianCalendar gCal = new GregorianCalendar(year, month, day, hour, minute, 0);
        uiInput.addTime(gCal.getTime());
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter w = context.getResponseWriter();
        UIDateTimeInput uiInput = (UIDateTimeInput)component;
        StringBuffer b = new StringBuffer(200);
        ResourceBundle res = DateTimeInputRenderer.getApplicationResourceBundle(context.getExternalContext());
        String name = uiInput.getName();
        Calendar cal = uiInput.getCalendar();
        this.renderField(b, uiInput, name + "_dd", cal.get(5), 1, cal.getActualMaximum(5));
        this.renderField(b, uiInput, name + "_mm", cal.get(2), this.buildMonthArray(res));
        this.renderField(b, uiInput, name + "_yyyy", cal.get(1), uiInput.getMinYearRange(), uiInput.getMaxYearRange());
        b.append("<div style='float:left; width: 20px'>&nbsp;</div>");
        this.renderField(b, uiInput, name + "_hh", cal.get(11), 0, 23);
        int minuteStep = uiInput.getMinuteStep_();
        if (minuteStep == 0) {
            minuteStep = 1;
        }
        this.renderField(b, uiInput, name + "_min", cal.get(12), 0, 59, minuteStep);
        w.write(b.toString());
        if (uiInput.hasError()) {
            w.write("<span style='color: red'>*</span>");
        }
    }

    private String[] buildMonthArray(ResourceBundle res) {
        String[] months = new String[12];
        for (int i = 0; i < months.length; ++i) {
            months[i] = res.getString("UIDateInput.month-" + i);
        }
        return months;
    }

    private void renderField(StringBuffer b, UIDateTimeInput uiInput, String name, int value, int minRange, int maxRange, int step) {
        b.append("<select  style='width: auto;' name='").append(name).append("'");
        if (!uiInput.isEditable() || uiInput.isReadonly()) {
            b.append(" disabled='true'");
        }
        if (uiInput.getClazz() != null) {
            b.append(" class='").append(uiInput.getClazz()).append("'");
        }
        if (uiInput.getUpdateOnChangeAction()) {
            UISimpleForm uiForm = (UISimpleForm)uiInput.getParent();
            String formName = uiForm.getFormName();
            b.append(" onchange=\"javascript:submitForm('").append(formName).append("','");
            b.append("change_").append(name).append("')\"");
        }
        b.append(">\n");
        DecimalFormat df = new DecimalFormat("00");
        for (int i = minRange; i <= maxRange; i += step) {
            if (i == value || i + step > value && i < value) {
                b.append("<option selected=\"selected\" value=\"").append(i).append("\">").append(df.format(i)).append("</option>\n");
                continue;
            }
            b.append("<option value=\"").append(i).append("\">").append(df.format(i)).append("</option>\n");
        }
        b.append("</select>\n");
    }

    private void renderField(StringBuffer b, UIDateTimeInput uiInput, String name, int value, int minRange, int maxRange) {
        this.renderField(b, uiInput, name, value, minRange, maxRange, 1);
    }

    private void renderField(StringBuffer b, UIDateTimeInput uiInput, String name, int value, String[] values) {
        b.append("<select style='width: auto;' name='").append(name).append("'");
        if (!uiInput.isEditable() || uiInput.isReadonly()) {
            b.append(" disabled='true'");
        }
        if (uiInput.getClazz() != null) {
            b.append(" class='").append(uiInput.getClazz()).append("'");
        }
        if (uiInput.getUpdateOnChangeAction()) {
            UISimpleForm uiForm = (UISimpleForm)uiInput.getParent();
            String formName = uiForm.getFormName();
            b.append(" onchange=\"javascript:submitForm('").append(formName).append("','");
            b.append("change_").append(name).append("')\"");
        }
        b.append(">\n");
        for (int i = 0; i < values.length; ++i) {
            if (i == value) {
                b.append("<option selected=\"selected\" value=\"").append(i).append("\">").append(values[i]).append("</option>\n");
                continue;
            }
            b.append("<option value=\"").append(i).append("\">").append(values[i]).append("</option>\n");
        }
        b.append("</select>\n");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }
}

