/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.renderer.html;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faces.core.component.ComponentTemplate;
import org.exoplatform.faces.core.component.UIExoComponent;
import org.exoplatform.faces.core.renderer.html.HtmlBasicRenderer;
import org.exoplatform.faces.core.renderer.html.JSF;
import org.exoplatform.services.templates.groovy.GroovyTemplateFileLoader;
import org.exoplatform.services.templates.groovy.GroovyTemplateLoader;
import org.exoplatform.services.templates.groovy.GroovyTemplateService;
import org.exoplatform.services.templates.groovy.TemplateNotFoundException;

public class GroovyRenderer
extends HtmlBasicRenderer {
    public void encodeChildren(FacesContext fcontext, UIComponent component) throws IOException {
        String realName = null;
        if (component instanceof ComponentTemplate) {
            realName = ((ComponentTemplate)component).getTemplatePath();
        } else {
            String name = component.getClass().getName();
            realName = name.replaceFirst("component", "renderer/html");
            realName = realName.replace('.', '/') + ".gtmpl";
        }
        GroovyTemplateService tservice = (GroovyTemplateService)PortalContainer.getComponent(GroovyTemplateService.class);
        ResponseWriter writer = fcontext.getResponseWriter();
        ResourceBundle res = GroovyRenderer.getApplicationResourceBundle(fcontext.getExternalContext());
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("uicomponent", component);
        binding.put("res", res);
        JSF jsf = new JSF((UIExoComponent)component, res, (Writer)writer);
        binding.put("jsf", jsf);
        try {
            tservice.merge((Writer)writer, null, realName, binding);
            return;
        }
        catch (TemplateNotFoundException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        ServletContext context = (ServletContext)fcontext.getExternalContext().getContext();
        String root = context.getRealPath("/");
        if (root == null) {
            throw new IOException("ServletContext does not support get real path, need to implement GroovyTemplateWarLoader");
        }
        GroovyTemplateFileLoader floader = new GroovyTemplateFileLoader(root + "/groovy");
        floader.setName(context.getServletContextName() + ":file");
        tservice.addTemplateLoader((GroovyTemplateLoader)floader);
        try {
            tservice.merge((Writer)writer, null, realName, binding);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }
}

