/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.renderer.html;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.exoplatform.faces.FacesUtil;
import org.exoplatform.faces.core.component.UIStringInput;
import org.exoplatform.faces.core.renderer.html.HtmlBasicRenderer;

public class StringInputRenderer
extends HtmlBasicRenderer {
    public void decode(FacesContext context, UIComponent component) {
        UIStringInput uiInput = (UIStringInput)component;
        if (uiInput.isReadonly()) {
            return;
        }
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)paramMap.get(uiInput.getName());
        if (value == null) {
            return;
        }
        if (!FacesUtil.updateBoundValueBinding(context, component, "text", value)) {
            uiInput.setText(value);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter w = context.getResponseWriter();
        UIStringInput uiInput = (UIStringInput)component;
        String value = uiInput.getValue();
        String type = "";
        String scripting = uiInput.getScripting();
        switch (uiInput.getType()) {
            case 0: {
                type = "text";
                break;
            }
            case 1: {
                type = "password";
            }
        }
        if (value == null) {
            value = "";
        }
        if (FacesUtil.isValueReference(value)) {
            value = (String)FacesUtil.resolveBoundValueBinding(context, (UIComponent)uiInput, "text");
        }
        w.write("<input name='");
        w.write(uiInput.getName());
        w.write("'");
        if (value == null) {
            value = "";
        }
        w.write(" value='");
        w.write(value);
        w.write("'");
        w.write(" type='");
        w.write(type);
        w.write("'");
        if (uiInput.getClazz() != null) {
            w.write(" class='");
            w.write(uiInput.getClazz());
            w.write("'");
        }
        if (uiInput.getTitle() != null) {
            w.write(" title='");
            w.write(uiInput.getTitle());
            w.write("'");
        }
        if (!uiInput.isEditable() || uiInput.isReadonly()) {
            w.write(" readonly='readonly' ");
        }
        if (scripting != null) {
            w.write(" " + scripting);
        }
        w.write(" alt='N/A'/>");
        if (uiInput.hasSelectors()) {
            Collection selectors = uiInput.getSelectors();
            for (String button : selectors) {
                w.write(button);
            }
        }
        if (uiInput.hasError()) {
            w.write("<span style='color: red'>*</span>");
        }
    }
}

