/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.renderer.html;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletContext;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faces.context.PortletFacesContext;
import org.exoplatform.faces.core.component.ComponentTemplate;
import org.exoplatform.faces.core.renderer.html.HtmlBasicRenderer;
import org.exoplatform.services.templates.velocity.StaticResourceLoader;
import org.exoplatform.services.templates.velocity.VelocityService;
import org.exoplatform.velocity.utils.VelocityUtils;

public class VelocityRenderer
extends HtmlBasicRenderer {
    public static SimpleDateFormat DateFormatter = new SimpleDateFormat();
    public static VelocityUtils velocityUtils = new VelocityUtils();

    protected Template getTemplate(UIComponent component, FacesContext fcontext) throws Exception {
        VelocityService vservice = (VelocityService)PortalContainer.getComponent(VelocityService.class);
        StaticResourceLoader srloader = vservice.getStaticResourceLoader();
        String name = null;
        String path = null;
        if (component instanceof ComponentTemplate) {
            name = path = ((ComponentTemplate)component).getTemplatePath();
        } else {
            name = component.getClass().getName();
            path = name.replaceFirst("component", "renderer/html");
            path = path.replace('.', '/') + ".vm";
        }
        try {
            Template template = srloader.getTemplate(name);
            if (template != null) {
                return template;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        URL url = null;
        if (fcontext instanceof PortletFacesContext) {
            PortletFacesContext pfcontext = (PortletFacesContext)fcontext;
            FacesContext pfContext = pfcontext.getPortalFacesContext();
            ServletContext context = (ServletContext)pfContext.getExternalContext().getContext();
            String newPath = context.getRealPath("/portlets/velocity/");
            if (newPath != null) {
                srloader.addPath(newPath);
            }
            url = this.getResource(context, "/portlets/velocity/" + path);
        }
        if (url == null) {
            ServletContext context = (ServletContext)fcontext.getExternalContext().getContext();
            String newPath = context.getRealPath("/velocity/");
            if (newPath != null) {
                srloader.addPath(newPath);
            }
            url = this.getResource(context, "/velocity/" + path);
        }
        if (url == null) {
            url = Thread.currentThread().getContextClassLoader().getResource(path);
        }
        if (url == null) {
            throw new Exception("Cannot  find the template " + path + " in the search path");
        }
        srloader.addTemplate(name, url);
        return vservice.getTemplate(name);
    }

    protected URL getResource(ServletContext scontext, String path) throws Exception {
        File file;
        String realPath = scontext.getRealPath(path);
        Integer integer = new Integer(1);
        URL url = null;
        if (realPath != null && (file = new File(realPath)).canRead()) {
            url = file.toURL();
        }
        if (url == null) {
            url = scontext.getResource(path);
        }
        return url;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter w = context.getResponseWriter();
        ResourceBundle res = VelocityRenderer.getApplicationResourceBundle(context.getExternalContext());
        try {
            Template template = this.getTemplate(component, context);
            VelocityContext vcontext = new VelocityContext();
            vcontext.put("uicomponent", (Object)component);
            vcontext.put("DateFormatter", (Object)DateFormatter);
            vcontext.put("res", (Object)res);
            vcontext.put("VelocityUtils", (Object)velocityUtils);
            template.merge((Context)vcontext, (Writer)w);
        }
        catch (Exception ex) {
            w.write("Render  Error: " + ex.getMessage());
            ex.printStackTrace();
        }
    }
}

