/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.velocity.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;
import org.exoplatform.faces.core.component.UICalendarInput;
import org.exoplatform.faces.core.component.UICheckBox;
import org.exoplatform.faces.core.component.UIDateInput;
import org.exoplatform.faces.core.component.UIInput;
import org.exoplatform.faces.core.component.UISimpleForm;
import org.exoplatform.faces.core.component.UIStringInput;
import org.exoplatform.faces.core.component.UIUploadInput;
import org.exoplatform.faces.core.event.ExoActionEvent;
import org.exoplatform.faces.core.event.ExoActionListener;

public class JSFFormField
extends Directive {
    public static final String DELETE_ACTION = "deleteValue";
    public static final String ADD_ACTION = "addValue";

    public String getName() {
        return "jsfFormField";
    }

    public int getType() {
        return 2;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws Exception {
        super.init(rs, context, node);
    }

    public boolean render(InternalContextAdapter context, Writer w, Node node) throws IOException, MethodInvocationException, ResourceNotFoundException, ParseErrorException {
        String mV;
        UISimpleForm uiForm = (UISimpleForm)context.get("uicomponent");
        String name = (String)node.jjtGetChild(0).value(context);
        boolean multivalue = false;
        int size = node.jjtGetNumChildren();
        if (size > 1 && "multivalue".equals(mV = (String)node.jjtGetChild(1).value(context))) {
            multivalue = true;
        }
        if (multivalue) {
            this.manageMultiValue(context, uiForm, w, name);
        } else {
            UIInput uiInput = uiForm.getUIInput(name);
            this.render(name, uiInput, w);
        }
        return true;
    }

    protected void manageMultiValue(InternalContextAdapter context, UISimpleForm uiForm, Writer w, String name) throws IOException {
        ResourceBundle res = (ResourceBundle)context.get("res");
        String deleteLabel = res.getString("JSFFormField.button.delete");
        String addLabel = res.getString("JSFFormField.button.add");
        List<UIInput> inputs = uiForm.getMultipleValuesUIInput(name);
        int size = inputs.size();
        int i = 0;
        for (UIInput uiInput : inputs) {
            String action = "";
            String button = "";
            if (i == 0 && size > 1) {
                this.removeSelectors(uiInput, ADD_ACTION);
            }
            if (i >= 1) {
                action = DELETE_ACTION + uiInput.getName();
                button = this.generateSelectorButton(uiForm.getFormName(), action, deleteLabel);
                this.removeSelectors(uiInput, ADD_ACTION);
                this.removeSelectors(uiInput, DELETE_ACTION);
                uiInput.addSelector(action, button);
                this.manageListener(uiForm, action);
            }
            if (i == size - 1) {
                action = ADD_ACTION + uiInput.getName();
                button = this.generateSelectorButton(uiForm.getFormName(), action, addLabel);
                this.removeSelectors(uiInput, ADD_ACTION);
                uiInput.addSelector(action, button);
                this.manageListener(uiForm, action);
            }
            w.write("<div class='multiField'>");
            this.render(name, uiInput, w);
            w.write("</div>");
            ++i;
        }
    }

    protected void manageListener(UISimpleForm uiForm, String actionToListen) {
        ActionListener[] listeners = uiForm.getActionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ExoActionListener listener = (ExoActionListener)listeners[i];
            if (!listener.getActionName().equals(actionToListen)) continue;
            return;
        }
        ExoActionListener listener = null;
        if (actionToListen.startsWith(DELETE_ACTION)) {
            listener = new DeleteActionListener();
        } else if (actionToListen.startsWith(ADD_ACTION)) {
            listener = new AddActionListener();
        }
        listener.setActionToListen(actionToListen);
        uiForm.addActionListener(listener);
    }

    protected void removeSelectors(UIInput input, String action) {
        if (input.hasSelectors()) {
            Collection selectors = input.getSelectorsAction();
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String selAction : selectors) {
                if (!selAction.startsWith(action)) continue;
                toRemove.add(selAction);
            }
            for (String actionToRemove : toRemove) {
                input.removeSelector(actionToRemove);
            }
        }
    }

    protected void render(String name, UIInput uiInput, Writer w) throws IOException {
        if (uiInput != null) {
            FacesContext facescontext = FacesContext.getCurrentInstance();
            uiInput.encodeBegin(facescontext);
            uiInput.encodeChildren(facescontext);
            uiInput.encodeEnd(facescontext);
        } else {
            w.write("#jsfFormField( Unknow Field Name: " + name + ")");
        }
    }

    protected String generateSelectorButton(String formName, String action, String label) {
        StringBuffer sB = new StringBuffer();
        sB.append("<a  href=\"javascript:submitForm('");
        sB.append(formName);
        sB.append("','");
        sB.append(action);
        sB.append("');\">");
        if (label == null) {
            sB.append("action");
        } else {
            sB.append(label);
        }
        sB.append("</a>");
        return sB.toString();
    }

    public class AddActionListener
    extends ExoActionListener {
        public void execute(ExoActionEvent event) throws Exception {
            UIInput input;
            String valueName;
            UISimpleForm uiForm = (UISimpleForm)event.getComponent();
            String action = event.getAction();
            String name = valueName = action.substring(JSFFormField.ADD_ACTION.length());
            int firstIndex = valueName.indexOf("[");
            if (firstIndex > 0) {
                name = valueName.substring(0, firstIndex);
            }
            if ((input = uiForm.getUIInput(valueName)) instanceof UIUploadInput) {
                uiForm.addValue(new UIUploadInput(name));
            } else if (input instanceof UICheckBox) {
                uiForm.addValue(new UICheckBox(name, "quoted"));
            } else if (input instanceof UIDateInput) {
                uiForm.addValue(new UIDateInput(name, new Date()));
            } else if (input instanceof UICalendarInput) {
                uiForm.addValue(new UICalendarInput(name, ""));
            } else {
                uiForm.addValue(new UIStringInput(name, ""));
            }
        }
    }

    public class DeleteActionListener
    extends ExoActionListener {
        public void execute(ExoActionEvent event) throws Exception {
            UISimpleForm uiForm = (UISimpleForm)event.getComponent();
            String action = event.getAction();
            String inputName = action.substring(JSFFormField.DELETE_ACTION.length());
            uiForm.removeValue(inputName);
        }
    }
}

