/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.pci;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.portletcontainer.pci.WindowID;

public class ExoWindowID
implements WindowID {
    public static final String DEFAULT_PORTAL_CONFIG = "default-portal-config";
    public static final String MOBILE_PORTAL_CONFIG = "default-portal-config";
    private String owner;
    private String portletApplicationName;
    private String portletName;
    private String uniqueID;
    private String persistenceId;
    private String configurationSource = "default-portal-config";

    public ExoWindowID() {
    }

    public ExoWindowID(String persistenceId) {
        this.persistenceId = persistenceId;
        int idx = persistenceId.indexOf(":/");
        this.owner = persistenceId.substring(0, idx);
        persistenceId = persistenceId.substring(idx + 2, persistenceId.length());
        String[] keys = StringUtils.split((String)persistenceId, (String)"/");
        this.portletApplicationName = keys[0];
        this.portletName = keys[1];
        this.uniqueID = keys[2];
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getPortletApplicationName() {
        return this.portletApplicationName;
    }

    public void setPortletApplicationName(String portletApplicationName) {
        this.portletApplicationName = portletApplicationName;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public void setPortletName(String portletName) {
        this.portletName = portletName;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public void setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    public String getPersistenceId() {
        return this.persistenceId;
    }

    public void setPersistenceId(String id) {
        this.persistenceId = id;
    }

    public String generatePersistenceId() {
        return this.owner + ":/" + this.portletApplicationName + "/" + this.portletName + "/" + this.uniqueID;
    }

    public String generateKey() {
        return this.uniqueID;
    }

    public String getConfigurationSource() {
        return this.configurationSource;
    }

    public void setConfigurationSource(String source) {
        this.configurationSource = source;
    }
}

