/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.portletcontainer.impl.config.CustomMode;
import org.exoplatform.services.portletcontainer.impl.config.CustomWindowState;
import org.exoplatform.services.portletcontainer.impl.config.Description;
import org.exoplatform.services.portletcontainer.impl.config.PortletContainer;
import org.exoplatform.services.portletcontainer.impl.config.Properties;
import org.exoplatform.services.portletcontainer.impl.config.SharedSession;
import org.exoplatform.services.portletcontainer.impl.config.SupportedContent;
import org.exoplatform.services.portletcontainer.pci.CustomModeWithDescription;
import org.exoplatform.services.portletcontainer.pci.CustomWindowStateWithDescription;
import org.exoplatform.services.portletcontainer.pci.LocalisedDescription;

public class PortletContainerConf {
    private Map properties;
    private String portletContainerName;
    private int majorVersion = -1;
    private int minorVersion = -1;
    private Collection customModes;
    private Collection customStates;
    private Collection customModesWithDescriptions;
    private Collection customStatesWithDescriptions;
    private Collection supportedContents;
    private boolean isCacheEnable;
    private boolean isSharedSessionEnable;
    private PortletContainer containerConfs;
    private boolean isBundleLookupDelegated;

    public PortletContainerConf(InitParams params, ConfigurationManager cmanager, LogService logService) {
        try {
            ObjectParameter param2 = params.getObjectParam("conf");
            this.containerConfs = (PortletContainer)param2.getObject();
            this.init();
        }
        catch (Exception e) {
            Log log = logService.getLog("org.exoplatform.services.portletcontainer");
            log.error((Object)(" -- PortletContainerConf.<init>: " + e));
        }
    }

    private void init() {
        SharedSession sharedSession;
        String c = this.containerConfs.getCache().getEnable();
        if ("true".equals(c)) {
            this.isCacheEnable = true;
        }
        if ((sharedSession = this.containerConfs.getSharedSession()) != null && "true".equals(c = sharedSession.getEnable())) {
            this.isSharedSessionEnable = true;
        }
        if ("true".equals(c = this.containerConfs.getDelegatedBundle().getEnable())) {
            this.isBundleLookupDelegated = true;
        }
    }

    public Map getProperties() {
        if (this.properties == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            List l = this.containerConfs.getProperties();
            for (Properties props : l) {
                map.put(props.getName(), props.getValue());
            }
            this.properties = map;
        }
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public String getPortletContainerName() {
        if (this.portletContainerName == null) {
            this.portletContainerName = this.containerConfs.getGlobal().getName();
        }
        return this.portletContainerName;
    }

    public void setPortletContainerName(String name) {
        this.portletContainerName = name;
    }

    public int getMajorVersion() {
        if (this.majorVersion < 0) {
            this.majorVersion = this.containerConfs.getGlobal().getMajorVersion();
        }
        return this.majorVersion;
    }

    public void setMajorVersion(int version) {
        this.majorVersion = version;
    }

    public int getMinorVersion() {
        if (this.minorVersion < 0) {
            this.minorVersion = this.containerConfs.getGlobal().getMinorVersion();
        }
        return this.minorVersion;
    }

    public void setMinorVersion(int version) {
        this.minorVersion = version;
    }

    public Collection getSupportedContent() {
        if (this.supportedContents == null) {
            this.supportedContents = new ArrayList();
            List content = this.containerConfs.getSupportedContent();
            for (SupportedContent element : content) {
                this.supportedContents.add(element.getName());
            }
        }
        return this.supportedContents;
    }

    public Enumeration getSupportedPortletModes() {
        if (this.customModes == null) {
            ArrayList<PortletMode> v = new ArrayList<PortletMode>();
            v.add(PortletMode.EDIT);
            v.add(PortletMode.HELP);
            v.add(PortletMode.VIEW);
            List l = this.containerConfs.getCustomMode();
            for (CustomMode customMode : l) {
                v.add(new PortletMode(customMode.getName()));
            }
            this.customModes = v;
        }
        return Collections.enumeration(this.customModes);
    }

    public Enumeration getSupportedWindowStates() {
        if (this.customStates == null) {
            ArrayList<WindowState> v = new ArrayList<WindowState>();
            v.add(WindowState.NORMAL);
            v.add(WindowState.MINIMIZED);
            v.add(WindowState.MAXIMIZED);
            List l = this.containerConfs.getCustomWindowState();
            for (CustomWindowState customState : l) {
                v.add(new WindowState(customState.getName()));
            }
            this.customStates = v;
        }
        return Collections.enumeration(this.customStates);
    }

    public Collection getSupportedPortletModesWithDescriptions() {
        if (this.customModesWithDescriptions == null) {
            ArrayList<CustomModeWithDescription> v = new ArrayList<CustomModeWithDescription>();
            List l = this.containerConfs.getCustomMode();
            for (CustomMode customMode : l) {
                List l2 = customMode.getDescription();
                ArrayList<LocalisedDescription> toBeReturned = new ArrayList<LocalisedDescription>();
                for (Description element : l2) {
                    LocalisedDescription d = new LocalisedDescription(new Locale(element.getLang()), element.getDescription());
                    toBeReturned.add(d);
                }
                CustomModeWithDescription cMWD = new CustomModeWithDescription(new PortletMode(customMode.getName()), toBeReturned);
                v.add(cMWD);
            }
            this.customModesWithDescriptions = v;
        }
        return this.customModesWithDescriptions;
    }

    public Collection getSupportedWindowStatesWithDescriptions() {
        if (this.customStatesWithDescriptions == null) {
            ArrayList<CustomWindowStateWithDescription> v = new ArrayList<CustomWindowStateWithDescription>();
            List l = this.containerConfs.getCustomWindowState();
            for (CustomWindowState customState : l) {
                List l2 = customState.getDescription();
                ArrayList<LocalisedDescription> toBeReturned = new ArrayList<LocalisedDescription>();
                for (Description element : l2) {
                    LocalisedDescription d = new LocalisedDescription(new Locale(element.getLang()), element.getDescription());
                    toBeReturned.add(d);
                }
                CustomWindowStateWithDescription cMWD = new CustomWindowStateWithDescription(new WindowState(customState.getName()), toBeReturned);
                v.add(cMWD);
            }
            this.customStatesWithDescriptions = v;
        }
        return this.customStatesWithDescriptions;
    }

    public synchronized void setCustomModesWithDescriptions(Collection customModesWithDescriptions) {
        this.customModesWithDescriptions = customModesWithDescriptions;
        ArrayList<PortletMode> temp = new ArrayList<PortletMode>();
        for (CustomModeWithDescription element : customModesWithDescriptions) {
            temp.add(element.getPortletMode());
        }
        this.customModes = temp;
    }

    public synchronized void setCustomStatesWithDescriptions(Collection customStatesWithDescriptions) {
        this.customStatesWithDescriptions = customStatesWithDescriptions;
        ArrayList<WindowState> temp = new ArrayList<WindowState>();
        for (CustomWindowStateWithDescription element : customStatesWithDescriptions) {
            temp.add(element.getWindowState());
        }
        this.customStates = temp;
    }

    public boolean isModeSupported(PortletMode mode) {
        Enumeration e = this.getSupportedPortletModes();
        while (e.hasMoreElements()) {
            PortletMode portletMode = (PortletMode)e.nextElement();
            if (!portletMode.toString().equals(mode.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean isStateSupported(WindowState state) {
        Enumeration e = this.getSupportedWindowStates();
        while (e.hasMoreElements()) {
            WindowState windowState = (WindowState)e.nextElement();
            if (!windowState.toString().equals(state.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean isCacheEnable() {
        return this.isCacheEnable;
    }

    public boolean isSharedSessionEnable() {
        return this.isSharedSessionEnable;
    }

    public boolean isBundleLookupDelegated() {
        return this.isBundleLookupDelegated;
    }
}

