/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.ReadOnlyException;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.Environment;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.services.portletcontainer.helper.PortletWindowInternal;
import org.exoplatform.services.portletcontainer.impl.PortletApplicationHandler;
import org.exoplatform.services.portletcontainer.impl.PortletApplicationsHolder;
import org.exoplatform.services.portletcontainer.impl.PortletContainerConf;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.PortletPreferencesImp;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.persistenceImp.PersistenceManager;
import org.exoplatform.services.portletcontainer.pci.ActionInput;
import org.exoplatform.services.portletcontainer.pci.ActionOutput;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.Output;
import org.exoplatform.services.portletcontainer.pci.RenderInput;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.portletcontainer.pci.model.ExoPortletPreferences;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;

public class PortletContainerDispatcher {
    public static final String INPUT = "org.exoplatform.services.portletcontainer.pci.Input";
    public static final String OUTPUT = "org.exoplatform.services.portletcontainer.pci.Output";
    public static final String WINDOW_INFO = "org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers.PortletWindowInternal";
    public static final String IS_ACTION = "org.exoplatform.services.portletcontainer.impl.isAction";
    public static final String IS_TO_GET_BUNDLE = "org.exoplatform.services.portletcontainer.impl.isToGetBundle";
    public static final String LOCALE_FOR_BUNDLE = "org.exoplatform.services.portletcontainer.impl.LocaleForBundle";
    public static final String BUNDLE = "org.exoplatform.services.portletcontainer.impl.Bundle";
    public static String PORTLET_APPLICATION_NAME = "org.exoplatform.services.portletcontainer.impl.PortletAppName";
    public static String PORTLET_NAME = "org.exoplatform.services.portletcontainer.impl.PortletName";
    public static final String CONTAINER = "org.exoplatform.container.ExoContainer";
    public static final String SERVLET_MAPPING = "/PortletWrapper";
    public static final String ATTRS = "org.exoplatform.services.portletcontainer.pci.ATTRS";
    private PortletContainerConf containerConf;
    private PersistenceManager manager;
    private PortletApplicationsHolder portletApplications;
    private PortletApplicationHandler standAloneHandler;
    private Log log;
    protected ExoContainer cont;

    public PortletContainerDispatcher(PortletContainerConf containerConf, PersistenceManager manager, PortletApplicationsHolder holder, PortletApplicationHandler standAloneHandler, LogService logService, ExoContainerContext context) {
        this.portletApplications = holder;
        this.containerConf = containerConf;
        this.manager = manager;
        this.standAloneHandler = standAloneHandler;
        this.log = logService.getLog("org.exoplatform.services.portletcontainer");
        this.cont = context.getContainer();
    }

    public void setPortletContainerName(String containerName) {
        this.containerConf.setPortletContainerName(containerName);
    }

    public void setMajorVersion(int majorVersion) {
        this.containerConf.setMajorVersion(majorVersion);
    }

    public void setMinorVersion(int minorVersion) {
        this.containerConf.setMinorVersion(minorVersion);
    }

    public void setProperties(Map properties) {
        this.containerConf.setProperties(properties);
    }

    public void setSupportedPortletModesWithDescriptions(Collection portletModes) {
        this.containerConf.setCustomModesWithDescriptions(portletModes);
    }

    public void setSupportedWindowStatesWithDescriptions(Collection customStates) {
        this.containerConf.setCustomStatesWithDescriptions(customStates);
    }

    public Collection getSupportedPortletModesWithDescriptions() {
        return this.containerConf.getSupportedPortletModesWithDescriptions();
    }

    public Collection getSupportedWindowStatesWithDescriptions() {
        return this.containerConf.getSupportedWindowStatesWithDescriptions();
    }

    public Collection getSupportedPortletModes() {
        return Collections.list(this.containerConf.getSupportedPortletModes());
    }

    public Collection getSupportedWindowStates() {
        return Collections.list(this.containerConf.getSupportedWindowStates());
    }

    public Collection getPortletModes(String portletAppName, String portletName, String markup) {
        ArrayList<PortletMode> filteredModes = new ArrayList<PortletMode>();
        Collection nonFilteredModes = this.portletApplications.getPortletModes(portletAppName, portletName, markup);
        for (PortletMode mode : nonFilteredModes) {
            Enumeration portalModes = this.containerConf.getSupportedPortletModes();
            while (portalModes.hasMoreElements()) {
                PortletMode portalMode = (PortletMode)portalModes.nextElement();
                if (!mode.equals((Object)portalMode)) continue;
                filteredModes.add(mode);
            }
        }
        return filteredModes;
    }

    public boolean isModeSuported(String portletAppName, String portletName, String markup, PortletMode mode) {
        boolean isPortalMode = false;
        Enumeration portalModes = this.containerConf.getSupportedPortletModes();
        while (portalModes.hasMoreElements()) {
            PortletMode portalMode = (PortletMode)portalModes.nextElement();
            if (!portalMode.equals((Object)mode)) continue;
            isPortalMode = true;
            break;
        }
        return this.portletApplications.isModeSuported(portletAppName, portletName, markup, mode) && isPortalMode;
    }

    public Collection getWindowStates(String portletAppName) {
        ArrayList<WindowState> filteredStates = new ArrayList<WindowState>();
        Collection nonFilteredStates = this.portletApplications.getWindowStates(portletAppName);
        for (WindowState state : nonFilteredStates) {
            Enumeration portalStates = this.containerConf.getSupportedWindowStates();
            while (portalStates.hasMoreElements()) {
                WindowState portalState = (WindowState)portalStates.nextElement();
                if (!state.equals((Object)portalState)) continue;
                filteredStates.add(state);
            }
        }
        return filteredStates;
    }

    public boolean isStateSupported(WindowState state, String portletApplication) {
        boolean isPortalState = false;
        Enumeration portalStates = this.containerConf.getSupportedWindowStates();
        while (portalStates.hasMoreElements()) {
            WindowState portalState = (WindowState)portalStates.nextElement();
            if (!portalState.equals((Object)state)) continue;
            isPortalState = true;
            break;
        }
        return this.portletApplications.isStateSupported(state, portletApplication) && isPortalState;
    }

    public Map getAllPortletMetaData() {
        return this.portletApplications.getAllPortletMetaData(this.cont);
    }

    public void setPortletPreference(Input input, Map preferencesMap) throws PortletContainerException {
        this.log.debug((Object)"try to set a portlet preference directly from the setPortletPreference() method");
        WindowID windowID = input.getWindowID();
        Portlet pDatas = this.portletApplications.getPortletMetaData(windowID.getPortletApplicationName(), windowID.getPortletName());
        ExoPortletPreferences defaultPrefs = pDatas.getPortletPreferences();
        PortletWindowInternal windowInfos = this.manager.getWindow(input, defaultPrefs);
        PortletPreferencesImp preferences = (PortletPreferencesImp)windowInfos.getPreferences();
        preferences.setMethodCalledIsAction(true);
        Set keys = preferencesMap.keySet();
        try {
            for (String key : keys) {
                try {
                    preferences.setValue(key, (String)preferencesMap.get(key));
                }
                catch (ReadOnlyException e) {
                    this.log.error((Object)"Can not set a property that has a ReadOnly tag set to true", (Throwable)e);
                }
            }
            preferences.store();
        }
        catch (Exception e) {
            this.log.error((Object)"Can not store a portlet preference", (Throwable)e);
            throw new PortletContainerException((Throwable)e);
        }
    }

    public Map getPortletPreference(Input input) {
        this.log.debug((Object)"Try to get a portlet preference directly from the getPortletPreference() method ");
        WindowID windowID = input.getWindowID();
        Portlet pDatas = this.portletApplications.getPortletMetaData(windowID.getPortletApplicationName(), windowID.getPortletName());
        ExoPortletPreferences defaultPrefs = pDatas.getPortletPreferences();
        PortletWindowInternal windowInfos = this.manager.getWindow(input, defaultPrefs);
        PortletPreferencesImp preferences = (PortletPreferencesImp)windowInfos.getPreferences();
        return preferences.getMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getBundle(HttpServletRequest request, HttpServletResponse response, String portletAppName, String portletName, Locale locale) throws PortletContainerException {
        this.log.debug((Object)("Try to get a bundle object for locale : " + locale));
        if (Environment.getInstance().getPlatform() == 1) {
            URLClassLoader oldCL = (URLClassLoader)Thread.currentThread().getContextClassLoader();
            this.initTests();
            try {
                ResourceBundle resourceBundle = this.standAloneHandler.getBundle(portletAppName, portletName, locale);
                return resourceBundle;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
        request.setAttribute(CONTAINER, (Object)this.cont.getContext().getName());
        request.setAttribute(IS_TO_GET_BUNDLE, (Object)new Boolean(true));
        request.setAttribute(LOCALE_FOR_BUNDLE, (Object)locale);
        request.setAttribute(PORTLET_APPLICATION_NAME, (Object)portletAppName);
        request.setAttribute(PORTLET_NAME, (Object)portletName);
        this.dispatch(request, response, portletAppName);
        ResourceBundle bundle = (ResourceBundle)request.getAttribute(BUNDLE);
        request.removeAttribute(CONTAINER);
        request.removeAttribute(IS_TO_GET_BUNDLE);
        request.removeAttribute(LOCALE_FOR_BUNDLE);
        request.removeAttribute(PORTLET_APPLICATION_NAME);
        request.removeAttribute(PORTLET_NAME);
        request.removeAttribute(BUNDLE);
        return bundle;
    }

    public ActionOutput processAction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionInput actionInput) throws PortletContainerException {
        this.log.debug((Object)"ProcessAction method in PortletContainerDispatcher entered");
        return (ActionOutput)this.process(httpServletRequest, httpServletResponse, (Input)actionInput, true);
    }

    public RenderOutput render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RenderInput renderInput) throws PortletContainerException {
        this.log.debug((Object)"Render method in PortletContainerDispatcher entered");
        try {
            httpServletResponse.flushBuffer();
        }
        catch (IOException e) {
            this.log.error((Object)"Can not flush servlet response buffer");
        }
        return (RenderOutput)this.process(httpServletRequest, httpServletResponse, (Input)renderInput, false);
    }

    public void sendAttrs(HttpServletRequest request, HttpServletResponse response, Map attrs, String portletApplicationName) throws PortletContainerException {
        request.setAttribute(CONTAINER, (Object)this.cont.getContext().getName());
        request.setAttribute(ATTRS, (Object)attrs);
        if (Environment.getInstance().getPlatform() != 1) {
            this.dispatch(request, response, portletApplicationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Output process(HttpServletRequest request, HttpServletResponse response, Input input, boolean isAction) throws PortletContainerException {
        this.log.debug((Object)"Process method in PortletContainerDispatcher entered");
        this.log.debug((Object)("Encoding used : " + request.getCharacterEncoding()));
        Object output = null;
        output = isAction ? new ActionOutput() : new RenderOutput();
        PortletWindowInternal windowInfos = this.getWindowInfos(request, input, isAction);
        String portletApplicationName = windowInfos.getWindowID().getPortletApplicationName();
        request.setAttribute(CONTAINER, (Object)this.cont.getContext().getName());
        request.setAttribute(INPUT, (Object)input);
        request.setAttribute(OUTPUT, output);
        request.setAttribute(WINDOW_INFO, (Object)windowInfos);
        request.setAttribute(IS_ACTION, (Object)new Boolean(isAction));
        if (Environment.getInstance().getPlatform() == 1) {
            this.log.debug((Object)"Stand alone environement : direct call to handler");
            URLClassLoader oldCL = (URLClassLoader)Thread.currentThread().getContextClassLoader();
            this.initTests();
            try {
                ServletContext portalContext = (ServletContext)this.cont.getComponentInstanceOfType(ServletContext.class);
                this.standAloneHandler.process(portalContext, request, response, input, (Output)output, windowInfos, isAction);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
        this.log.debug((Object)"Embded environement : use servlet dispatcher to access handler");
        try {
            this.dispatch(request, response, portletApplicationName);
        }
        finally {
            ((PortletPreferencesImp)windowInfos.getPreferences()).discard();
        }
        if (input.isStateSaveOnClient() && isAction) {
            try {
                this.log.debug((Object)"Serialize Portlet Preferences object to store it on the client");
                output.setPortletState(IOUtil.serialize((Object)windowInfos.getPreferences()));
            }
            catch (Exception e) {
                this.log.error((Object)"Can not serialize Portlet Preferences", (Throwable)e);
                throw new PortletContainerException("Can not serialize Portlet Preferences", (Throwable)e);
            }
        }
        return output;
    }

    private PortletWindowInternal getWindowInfos(HttpServletRequest request, Input input, boolean isAction) {
        boolean stateChangeAuthorized = true;
        if (isAction) {
            stateChangeAuthorized = ((ActionInput)input).isStateChangeAuthorized();
        }
        PortletWindowInternal windowInfos = null;
        if (!input.isStateSaveOnClient()) {
            this.log.debug((Object)"Extract or create windows info (store in the server)");
            SessionContainer sessionContainer = SessionContainer.getInstance();
            String key = "SESSION_CONTAINER_KEY_ENCODER" + input.getWindowID().generateKey();
            if (sessionContainer.getComponentInstance((Object)key) != null) {
                windowInfos = (PortletWindowInternal)sessionContainer.getComponentInstance((Object)key);
            } else {
                WindowID windowID = input.getWindowID();
                Portlet pDatas = this.portletApplications.getPortletMetaData(windowID.getPortletApplicationName(), windowID.getPortletName());
                ExoPortletPreferences defaultPrefs = pDatas.getPortletPreferences();
                windowInfos = this.manager.getWindow(input, defaultPrefs);
                sessionContainer.registerComponentInstance((Object)key, (Object)windowInfos);
            }
        } else {
            this.log.debug((Object)"Extract or create windows info (sent by the client)");
            WindowID windowID = input.getWindowID();
            Portlet pDatas = this.portletApplications.getPortletMetaData(windowID.getPortletApplicationName(), windowID.getPortletName());
            ExoPortletPreferences defaultPrefs = pDatas.getPortletPreferences();
            windowInfos = this.manager.getWindow(input, defaultPrefs);
        }
        ((PortletPreferencesImp)windowInfos.getPreferences()).setMethodCalledIsAction(isAction);
        ((PortletPreferencesImp)windowInfos.getPreferences()).setStateChangeAuthorized(stateChangeAuthorized);
        ((PortletPreferencesImp)windowInfos.getPreferences()).setStateSaveOnClient(input.isStateSaveOnClient());
        return windowInfos;
    }

    private void dispatch(HttpServletRequest request, HttpServletResponse response, String portletApplicationName) throws PortletContainerException {
        ServletContext portalContext = (ServletContext)this.cont.getComponentInstanceOfType(ServletContext.class);
        ServletContext portletContext = portalContext.getContext("/" + portletApplicationName);
        RequestDispatcher dispatcher = portletContext.getRequestDispatcher(SERVLET_MAPPING);
        try {
            this.log.debug((Object)("Dispatch resuest to the portlet application : " + portletApplicationName));
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            this.log.error((Object)"Servlet exception while dispatching to portlet", (Throwable)e);
            throw new PortletContainerException((Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Object)"In and out exception while dispatching to portlet", (Throwable)e);
            throw new PortletContainerException((Throwable)e);
        }
    }

    private void initTests() {
        String PORTLET_APP_PATH = "file:" + System.getProperty("testPath") + "/war_template";
        try {
            URL[] URLs = new URL[]{new URL(PORTLET_APP_PATH + "WEB-INF/classes/"), new URL("file:./lib/portlet-api.jar"), new URL(PORTLET_APP_PATH + "WEB-INF/lib/")};
        }
        catch (MalformedURLException e) {
            this.log.error((Object)"Can not init tests", (Throwable)e);
        }
    }
}

