/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.config;

import java.io.InputStream;
import org.exoplatform.commons.xml.ExoXPPParser;
import org.exoplatform.services.portletcontainer.impl.config.Cache;
import org.exoplatform.services.portletcontainer.impl.config.CustomMode;
import org.exoplatform.services.portletcontainer.impl.config.CustomWindowState;
import org.exoplatform.services.portletcontainer.impl.config.DelegatedBundle;
import org.exoplatform.services.portletcontainer.impl.config.Description;
import org.exoplatform.services.portletcontainer.impl.config.Global;
import org.exoplatform.services.portletcontainer.impl.config.PortletContainer;
import org.exoplatform.services.portletcontainer.impl.config.Properties;
import org.exoplatform.services.portletcontainer.impl.config.SharedSession;
import org.exoplatform.services.portletcontainer.impl.config.SupportedContent;

public class XMLParser {
    public static PortletContainer readPortletContainer(ExoXPPParser xpp) throws Exception {
        PortletContainer pc = new PortletContainer();
        xpp.mandatoryNode("global");
        pc.setGlobal(XMLParser.readGlobal(xpp));
        if (xpp.node("shared-session")) {
            pc.setSharedSession(XMLParser.readSharedSession(xpp));
        }
        if (xpp.node("delegated-bundle")) {
            pc.setDelegatedBundle(XMLParser.readDelegatedBundle(xpp));
        }
        if (xpp.node("cache")) {
            pc.setCache(XMLParser.readCache(xpp));
        }
        while (xpp.node("supported-content")) {
            pc.addSupportedContent(XMLParser.readSupportedContent(xpp));
        }
        while (xpp.node("custom-mode")) {
            pc.addCustomMode(XMLParser.readCustomMode(xpp));
        }
        while (xpp.node("custom-window-state")) {
            pc.addCustomWindowState(XMLParser.readCustomWindowState(xpp));
        }
        while (xpp.node("properties")) {
            pc.addProperties(XMLParser.readProperties(xpp));
        }
        return pc;
    }

    public static Global readGlobal(ExoXPPParser xpp) throws Exception {
        Global global = new Global();
        xpp.mandatoryNode("name");
        global.setName(xpp.getContent());
        if (xpp.node("description")) {
            global.setDescription(xpp.getContent());
        }
        xpp.mandatoryNode("major-version");
        global.setMajorVersion(Integer.parseInt(xpp.getContent()));
        xpp.mandatoryNode("minor-version");
        global.setMinorVersion(Integer.parseInt(xpp.getContent()));
        return global;
    }

    public static SharedSession readSharedSession(ExoXPPParser xpp) throws Exception {
        SharedSession ss = new SharedSession();
        xpp.mandatoryNode("enable");
        ss.setEnable(xpp.getContent());
        return ss;
    }

    public static DelegatedBundle readDelegatedBundle(ExoXPPParser xpp) throws Exception {
        DelegatedBundle dB = new DelegatedBundle();
        xpp.mandatoryNode("enable");
        dB.setEnable(xpp.getContent());
        return dB;
    }

    public static Cache readCache(ExoXPPParser xpp) throws Exception {
        Cache cache = new Cache();
        xpp.mandatoryNode("enable");
        cache.setEnable(xpp.getContent());
        return cache;
    }

    public static Description readDescription(ExoXPPParser xpp) throws Exception {
        Description desc = new Description();
        desc.setLang(xpp.getNodeAttributeValue("lang"));
        desc.setDescription(xpp.getContent());
        return desc;
    }

    public static SupportedContent readSupportedContent(ExoXPPParser xpp) throws Exception {
        SupportedContent supportedContent = new SupportedContent();
        xpp.mandatoryNode("name");
        supportedContent.setName(xpp.getContent());
        return supportedContent;
    }

    public static CustomMode readCustomMode(ExoXPPParser xpp) throws Exception {
        CustomMode cmode = new CustomMode();
        xpp.mandatoryNode("name");
        cmode.setName(xpp.getContent());
        while (xpp.node("description")) {
            cmode.addDescription(XMLParser.readDescription(xpp));
        }
        return cmode;
    }

    public static Properties readProperties(ExoXPPParser xpp) throws Exception {
        Properties props = new Properties();
        xpp.mandatoryNode("description");
        props.setDescription(xpp.getContent());
        xpp.mandatoryNode("name");
        props.setName(xpp.getContent());
        xpp.mandatoryNode("value");
        props.setValue(xpp.getContent());
        return props;
    }

    public static CustomWindowState readCustomWindowState(ExoXPPParser xpp) throws Exception {
        CustomWindowState state = new CustomWindowState();
        xpp.mandatoryNode("name");
        state.setName(xpp.getContent());
        while (xpp.node("description")) {
            state.addDescription(XMLParser.readDescription(xpp));
        }
        return state;
    }

    public static PortletContainer parse(InputStream is) throws Exception {
        ExoXPPParser xpp = ExoXPPParser.getInstance();
        xpp.setInput(is, "UTF8");
        xpp.mandatoryNode("portlet-container");
        return XMLParser.readPortletContainer(xpp);
    }
}

