/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.monitor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.portletcontainer.impl.monitor.CachedDataImpl;
import org.exoplatform.services.portletcontainer.impl.monitor.PortletRuntimeDatasImpl;
import org.exoplatform.services.portletcontainer.monitor.CachedData;
import org.exoplatform.services.portletcontainer.monitor.PortletContainerMonitor;
import org.exoplatform.services.portletcontainer.monitor.PortletRuntimeData;

public class PortletContainerMonitorImpl
implements PortletContainerMonitor {
    public static final char SEPARATOR = '/';
    public static Map versionNumberMap = new HashMap();
    private Map runtimeDatas_;
    private Map destroyedPortlets_;
    private Map brokenPortlets_;
    private Log log_;
    private ExoCache globalCache_;
    private CacheService cacheService_;

    public PortletContainerMonitorImpl(LogService logService, CacheService cacheService) throws Exception {
        this.log_ = logService.getLog("org.exoplatform.services.portletcontainer");
        this.cacheService_ = cacheService;
        this.globalCache_ = cacheService.getCacheInstance("jsr168:forAll");
        this.runtimeDatas_ = Collections.synchronizedMap(new HashMap());
        this.brokenPortlets_ = Collections.synchronizedMap(new HashMap());
        this.destroyedPortlets_ = Collections.synchronizedMap(new HashMap());
    }

    public Map getPortletRuntimeDataMap() {
        return this.runtimeDatas_;
    }

    public PortletRuntimeDatasImpl getPortletRuntimeData(String appName, String portletName) {
        return (PortletRuntimeDatasImpl)this.runtimeDatas_.get(appName + '/' + portletName);
    }

    public synchronized void registerPortletApp(String portletApplicationName) {
        long versionNumber = 1L;
        if (versionNumberMap.get(portletApplicationName) != null) {
            versionNumber = (Long)versionNumberMap.get(portletApplicationName) + 1L;
        }
        versionNumberMap.put(portletApplicationName, new Long(versionNumber));
    }

    public long getPortletVersionNumber(String portletAppName) {
        return (Long)versionNumberMap.get(portletAppName);
    }

    public synchronized void register(String portletApplicationName, String portletName) {
        PortletRuntimeDatasImpl rD = new PortletRuntimeDatasImpl(portletApplicationName, portletName, this.cacheService_, this.globalCache_, this.log_);
        this.runtimeDatas_.put(portletApplicationName + '/' + portletName, rD);
        this.brokenPortlets_.remove(portletApplicationName + '/' + portletName);
        this.destroyedPortlets_.remove(portletApplicationName + '/' + portletName);
    }

    public boolean isInitialized(String portletAppName, String portletName) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        if (datas == null) {
            return false;
        }
        return datas.isInitialized();
    }

    public synchronized void init(String portletAppName, String portletName, int cacheExpirationTime) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        datas.setInitialized(true);
        datas.setCacheExpirationPeriod(cacheExpirationTime);
    }

    public synchronized void brokePortlet(String portletAppName, String portletName) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        if (datas == null) {
            datas = (PortletRuntimeData)this.destroyedPortlets_.get(portletAppName + '/' + portletName);
            this.destroyedPortlets_.remove(portletAppName + '/' + portletName);
        }
        this.runtimeDatas_.remove(portletAppName + '/' + portletName);
        this.brokenPortlets_.put(portletAppName + '/' + portletName, datas);
    }

    public boolean isBroken(String portletAppName, String portletName) {
        PortletRuntimeData datas = (PortletRuntimeData)this.brokenPortlets_.get(portletAppName + '/' + portletName);
        return datas != null;
    }

    public boolean isDestroyed(String portletAppName, String portletName) {
        PortletRuntimeData datas = (PortletRuntimeData)this.destroyedPortlets_.get(portletAppName + '/' + portletName);
        return datas != null;
    }

    public boolean isAvailable(String portletApplicationName, String portletName, long l) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletApplicationName + '/' + portletName);
        if (datas == null) {
            return false;
        }
        return datas.isAvailable(l);
    }

    public boolean isAvailable(String portletApplicationName, String portletName) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletApplicationName + '/' + portletName);
        if (datas == null) {
            return false;
        }
        return datas.isAvailable(System.currentTimeMillis());
    }

    public long whenAvailable(String portletApplicationName, String portletName) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletApplicationName + '/' + portletName);
        if (datas == null) {
            return -1L;
        }
        if (datas.isAvailable(System.currentTimeMillis())) {
            return 0L;
        }
        return datas.whenAvailable();
    }

    public boolean isInitialisationAllowed(String portletApplicationName, String portletName, long l) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletApplicationName + '/' + portletName);
        if (datas == null) {
            return false;
        }
        return datas.isInitialisationAllowed(l);
    }

    public synchronized void destroy(String portletApplicationName, String portletName) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas_.get(portletApplicationName + '/' + portletName);
        if (datas == null) {
            return;
        }
        this.runtimeDatas_.remove(portletApplicationName + '/' + portletName);
        this.destroyedPortlets_.put(portletApplicationName + '/' + portletName, datas);
    }

    public void setLastAccessTime(String portletAppName, String portletName, long l) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        if (datas == null) {
            datas = (PortletRuntimeDatasImpl)this.brokenPortlets_.get(portletAppName + '/' + portletName);
        }
        if (datas == null) {
            datas = (PortletRuntimeDatasImpl)this.destroyedPortlets_.get(portletAppName + '/' + portletName);
        }
        datas.setLastAccessTime(l);
    }

    public void setLastInitFailureAccessTime(String portletAppName, String portletName, long l) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        datas.setLastInitFailureAccessTime(l);
    }

    public void setLastFailureAccessTime(String portletAppName, String portletName, long l) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        datas.setLastFailureAccessTime(l);
    }

    public void setUnavailabilityPeriod(String portletAppName, String portletName, int unavailableSeconds) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        datas.setUnavailabilityPeriod(unavailableSeconds * 1000);
    }

    public boolean isDataCached(String portletApplicationName, String portletName, String key, boolean isCacheGlobal) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas_.get(portletApplicationName + '/' + portletName);
        return datas.isDataCached(key, isCacheGlobal);
    }

    public void removeCachedData(String portletApplicationName, String portletName, String key, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletApplicationName + '/' + portletName);
        datas.removeCachedData(key, isCacheGlobal);
    }

    public int getCacheExpirationPeriod(String portletApplicationName, String portletName) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas_.get(portletApplicationName + '/' + portletName);
        return datas.getCacheExpirationPeriod();
    }

    public void setCacheExpirationPeriod(String portletAppName, String portletName, int i) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        datas.setCacheExpirationPeriod(i);
    }

    public long getPortletLastAccessTime(String portletAppName, String portletName, String key, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        CachedData cachedData = datas.getCachedData(key, isCacheGlobal);
        if (cachedData != null) {
            return ((CachedDataImpl)cachedData).getLastAccessTime();
        }
        return 0L;
    }

    public void setPortletLastAccessTime(String portletAppName, String portletName, String key, long lastAccessTime, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        CachedDataImpl cachedData = (CachedDataImpl)datas.getCachedData(key, isCacheGlobal);
        if (cachedData == null) {
            cachedData = new CachedDataImpl();
            cachedData.setLastAccessTime(lastAccessTime);
            datas.setCachedData(key, cachedData, isCacheGlobal);
        } else {
            cachedData.setLastAccessTime(lastAccessTime);
        }
    }

    public void setCachedTitle(String portletAppName, String portletName, String key, String title, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        CachedDataImpl cachedData = (CachedDataImpl)datas.getCachedData(key, isCacheGlobal);
        if (cachedData == null) {
            cachedData = new CachedDataImpl();
            cachedData.setTitle(title);
            datas.setCachedData(key, cachedData, isCacheGlobal);
        } else {
            cachedData.setTitle(title);
        }
    }

    public String getCachedTitle(String portletAppName, String portletName, String key, boolean isCacheGlobal) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        CachedData cachedData = datas.getCachedData(key, isCacheGlobal);
        if (cachedData != null) {
            return cachedData.getTitle();
        }
        return null;
    }

    public void setCachedContent(String portletAppName, String portletName, String key, char[] content, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        CachedDataImpl cachedData = (CachedDataImpl)datas.getCachedData(key, isCacheGlobal);
        if (cachedData == null) {
            cachedData = new CachedDataImpl();
            cachedData.setContent(content);
            datas.setCachedData(key, cachedData, isCacheGlobal);
        } else {
            cachedData.setContent(content);
        }
    }

    public char[] getCachedContent(String portletAppName, String portletName, String key, boolean isCacheGlobal) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        CachedData cachedData = datas.getCachedData(key, isCacheGlobal);
        if (cachedData != null) {
            return cachedData.getContent();
        }
        return null;
    }

    public void setCachedMode(String portletAppName, String portletName, String key, PortletMode mode, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        CachedDataImpl cachedData = (CachedDataImpl)datas.getCachedData(key, isCacheGlobal);
        if (cachedData == null) {
            cachedData = new CachedDataImpl();
            cachedData.setMode(mode);
            datas.setCachedData(key, cachedData, isCacheGlobal);
        } else {
            cachedData.setMode(mode);
        }
    }

    public void setCachedWindowState(String portletAppName, String portletName, String key, WindowState window, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        CachedDataImpl cachedData = (CachedDataImpl)datas.getCachedData(key, isCacheGlobal);
        if (cachedData == null) {
            cachedData = new CachedDataImpl();
            cachedData.setWindowState(window);
            datas.setCachedData(key, cachedData, isCacheGlobal);
        } else {
            cachedData.setWindowState(window);
        }
    }

    public boolean needsCacheInvalidation(String portletAppName, String portletName, String key, PortletMode mode, WindowState window, boolean isCacheGlobal) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        CachedData cachedData = datas.getCachedData(key, isCacheGlobal);
        if (cachedData == null) {
            return false;
        }
        return cachedData.getMode() != mode || cachedData.getWindowState() != window;
    }

    public void setInitializationTime(String portletAppName, String portletName, long accessTime) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        datas.setInitializationTime(accessTime);
    }

    public long getInitializationTime(String portletAppName, String portletName) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas_.get(portletAppName + '/' + portletName);
        return datas.getInitializationTime();
    }
}

