/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.portletAPIImp;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.portletcontainer.impl.PortletContainerConf;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.PortletResponseImp;
import org.exoplatform.services.portletcontainer.pci.ActionOutput;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.Supports;

public class ActionResponseImp
extends PortletResponseImp
implements ActionResponse {
    private String location;
    private boolean sendRedirectAlreadyOccured;
    private boolean redirectionPossible;
    private Input input;
    private Portlet portletDatas;

    public ActionResponseImp(ExoContainer cont, HttpServletResponse httpServletResponse) {
        super(cont, httpServletResponse);
    }

    public void fillActionResponse(Input input, Portlet portletDatas) {
        this.portletDatas = portletDatas;
        this.input = input;
        this.redirectionPossible = true;
        this.sendRedirectAlreadyOccured = false;
    }

    public void emptyActionResponse() {
        this.redirectionPossible = false;
        this.sendRedirectAlreadyOccured = false;
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (this.sendRedirectAlreadyOccured) {
            throw new IllegalStateException("sendRedirect was already called");
        }
        if (windowState == null) {
            throw new WindowStateException("The portlet mode is null", windowState);
        }
        if (windowState == WindowState.NORMAL || windowState == WindowState.MINIMIZED || windowState == WindowState.MAXIMIZED) {
            ((ActionOutput)super.getOutput()).setNextState(windowState);
            this.redirectionPossible = false;
            return;
        }
        ExoContainer manager = this.cont;
        Enumeration e = ((PortletContainerConf)manager.getComponentInstanceOfType(PortletContainerConf.class)).getSupportedWindowStates();
        while (e.hasMoreElements()) {
            WindowState state = (WindowState)e.nextElement();
            if (!state.toString().equals(windowState.toString())) continue;
            ((ActionOutput)super.getOutput()).setNextState(windowState);
            this.redirectionPossible = false;
            return;
        }
        throw new WindowStateException("The window state " + windowState.toString() + " is not supported by the portlet container", windowState);
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (this.sendRedirectAlreadyOccured) {
            throw new IllegalStateException("sendRedirect was already called");
        }
        if (portletMode == null) {
            throw new PortletModeException("The portlet mode is null", portletMode);
        }
        if (portletMode == PortletMode.VIEW) {
            ((ActionOutput)super.getOutput()).setNextMode(portletMode);
            this.redirectionPossible = false;
            return;
        }
        List l = this.portletDatas.getSupports();
        for (Supports supports : l) {
            if (!this.input.getMarkup().equals(supports.getMimeType())) continue;
            List modeList = supports.getPortletMode();
            for (String modeString : modeList) {
                if ((modeString = modeString.toLowerCase()) == null || !modeString.equals(portletMode.toString())) continue;
                ((ActionOutput)super.getOutput()).setNextMode(portletMode);
                this.redirectionPossible = false;
                return;
            }
        }
        throw new PortletModeException("The mode " + portletMode.toString() + " is not supported by that portlet", portletMode);
    }

    public void setRenderParameters(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("the map given is null");
        }
        if (map.containsKey(null)) {
            throw new IllegalArgumentException("the map given contains a null key");
        }
        Set keys = map.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof String) continue;
            throw new IllegalArgumentException("the map contains a non String key");
        }
        Collection values = map.values();
        Iterator iter2 = values.iterator();
        while (iter2.hasNext()) {
            if (iter2.next() instanceof String[]) continue;
            throw new IllegalArgumentException("the map contains a non String[] value");
        }
        if (this.sendRedirectAlreadyOccured) {
            throw new IllegalStateException("sendRedirect was already called");
        }
        this.redirectionPossible = false;
        ((ActionOutput)super.getOutput()).setRenderParameters(map);
    }

    public void setRenderParameter(String s, String s1) {
        if (s == null) {
            throw new IllegalArgumentException("the key given is null");
        }
        if (s1 == null) {
            throw new IllegalArgumentException("the value given is null");
        }
        if (this.sendRedirectAlreadyOccured) {
            throw new IllegalStateException("sendRedirect was already called");
        }
        this.redirectionPossible = false;
        ((ActionOutput)super.getOutput()).setRenderParameter(s, s1);
    }

    public void setRenderParameter(String s, String[] strings) {
        if (s == null) {
            throw new IllegalArgumentException("the key given is null");
        }
        if (strings == null) {
            throw new IllegalArgumentException("the value given is null");
        }
        if (this.sendRedirectAlreadyOccured) {
            throw new IllegalStateException("sendRedirect was already called");
        }
        this.redirectionPossible = false;
        ((ActionOutput)super.getOutput()).setRenderParameters(s, strings);
    }

    public void sendRedirect(String location) throws IOException, IllegalArgumentException, IllegalStateException {
        if (!this.redirectionPossible) {
            throw new IllegalStateException(" The sendRedirect method can not be invoked after any of the following methods of the ActionResponse interface has been called: setPortletMode, setWindowState, setRenderParameter, setRenderParameters");
        }
        if (!(location.startsWith("/") || location.startsWith("http://") || location.startsWith("https://"))) {
            throw new IllegalArgumentException("a relative or incorrect path URL is given");
        }
        this.sendRedirectAlreadyOccured = true;
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isSendRedirectAlreadyOccured() {
        return this.sendRedirectAlreadyOccured;
    }
}

